/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

public final class FileFormat {
    public static final FileFormat DEFAULT = new FileFormat("DEFAULT", System.getProperty("line.separator"));
    public static final FileFormat AUTO = new FileFormat("AUTO", System.getProperty("line.separator"));
    public static final FileFormat DOS = new FileFormat("DOS", "\r\n");
    public static final FileFormat MAC = new FileFormat("MAC", "\r");
    public static final FileFormat UNIX = new FileFormat("UNIX", "\n");
    public static final FileFormat UNKNOWN = new FileFormat("UNKNOWN", System.getProperty("line.separator"));
    private final String _name;
    private final String _separator;

    private FileFormat(String name, String lineSeparator) {
        this._name = name.intern();
        this._separator = lineSeparator.intern();
    }

    public String getLineSeparator() {
        return this._separator;
    }

    public String getName() {
        return this._name;
    }

    public static FileFormat valueOf(String format) {
        FileFormat result = DEFAULT;
        if (format != null) {
            if (FileFormat.DOS._name == (format = format.toUpperCase().intern()) || FileFormat.DOS._separator == format) {
                result = DOS;
            } else if (FileFormat.UNIX._name == format || FileFormat.UNIX._separator == format) {
                result = UNIX;
            } else if (FileFormat.MAC._name == format || FileFormat.MAC._separator == format) {
                result = MAC;
            } else if (FileFormat.AUTO._name == format) {
                result = AUTO;
            } else if (FileFormat.UNKNOWN._name == format) {
                result = UNKNOWN;
            }
        }
        return result;
    }

    public String toString() {
        return this._separator;
    }
}

