/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXWriter;

public class JiBXDataSource
implements OMDataSource {
    private final String marshallerName;
    private final String elementName;
    private final String elementNamespace;
    private final String elementNamespacePrefix;
    private final int elementNamespaceIndex;
    private final int[] openNamespaceIndexes;
    private final String[] openNamespacePrefixes;
    private final Object dataObject;
    private final IBindingFactory bindingFactory;

    public JiBXDataSource(IMarshallable obj, IBindingFactory factory) {
        this.marshallerName = null;
        this.dataObject = obj;
        this.bindingFactory = factory;
        this.elementNamespacePrefix = null;
        this.elementNamespace = null;
        this.elementName = null;
        this.elementNamespaceIndex = -1;
        this.openNamespaceIndexes = null;
        this.openNamespacePrefixes = null;
    }

    public JiBXDataSource(Object obj, String mapping, String name, String uri, String prefix, int[] nsindexes, String[] nsprefixes, IBindingFactory factory) {
        int i;
        if (mapping == null) {
            throw new IllegalArgumentException("mapping name must be supplied");
        }
        this.marshallerName = mapping;
        this.dataObject = obj;
        this.bindingFactory = factory;
        boolean found = false;
        String[] nss = factory.getNamespaces();
        int nsidx = -1;
        for (i = 0; i < nsindexes.length; ++i) {
            if (!uri.equals(nss[nsindexes[i]])) continue;
            nsidx = nsindexes[i];
            prefix = nsprefixes[i];
            found = true;
            break;
        }
        this.elementName = name;
        this.elementNamespace = uri;
        this.elementNamespacePrefix = prefix;
        if (!found) {
            for (i = 0; i < nss.length; ++i) {
                if (!uri.equals(nss[i])) continue;
                nsidx = i;
                break;
            }
            if (nsidx >= 0) {
                int[] icpy = new int[nsindexes.length + 1];
                icpy[0] = nsidx;
                System.arraycopy(nsindexes, 0, icpy, 1, nsindexes.length);
                nsindexes = icpy;
                String[] scpy = new String[nsprefixes.length + 1];
                scpy[0] = prefix;
                System.arraycopy(nsprefixes, 0, scpy, 1, nsprefixes.length);
                nsprefixes = scpy;
            } else {
                throw new IllegalStateException("Namespace not found");
            }
        }
        this.elementNamespaceIndex = nsidx;
        this.openNamespaceIndexes = nsindexes;
        this.openNamespacePrefixes = nsprefixes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshal(boolean full, IMarshallingContext ctx) throws JiBXException {
        try {
            if (this.marshallerName == null) {
                if (!(this.dataObject instanceof IMarshallable)) throw new IllegalStateException("Object of class " + this.dataObject.getClass().getName() + " needs a JiBX <mapping> to be marshalled");
                ((IMarshallable)this.dataObject).marshal(ctx);
            } else {
                IXMLWriter wrtr = ctx.getXmlWriter();
                String name = this.elementName;
                int nsidx = 0;
                if (full) {
                    nsidx = this.elementNamespaceIndex;
                    wrtr.startTagNamespaces(nsidx, name, this.openNamespaceIndexes, this.openNamespacePrefixes);
                } else {
                    wrtr.openNamespaces(this.openNamespaceIndexes, this.openNamespacePrefixes);
                    if (!"".equals(this.elementNamespacePrefix)) {
                        name = this.elementNamespacePrefix + ':' + name;
                    }
                    wrtr.startTagOpen(0, name);
                }
                IMarshaller mrsh = ctx.getMarshaller(this.marshallerName);
                mrsh.marshal(this.dataObject, ctx);
                wrtr.endTag(nsidx, name);
            }
            ctx.getXmlWriter().flush();
            return;
        }
        catch (IOException e) {
            throw new JiBXException("Error marshalling XML representation: " + e.getMessage(), (Throwable)e);
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(output, format == null ? null : format.getCharSetEncoding());
            this.marshal(true, ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling: " + e.getMessage(), e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(writer);
            this.marshal(true, ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling: " + e.getMessage(), e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            String prefix;
            boolean full = true;
            String[] nss = this.bindingFactory.getNamespaces();
            if (this.marshallerName != null && this.elementNamespacePrefix.equals(prefix = xmlWriter.getPrefix(this.elementNamespace))) {
                full = false;
                for (int i = 0; i < this.openNamespaceIndexes.length; ++i) {
                    String uri = nss[i];
                    prefix = xmlWriter.getPrefix(uri);
                    if (this.openNamespacePrefixes[i].equals(prefix)) continue;
                    full = true;
                    break;
                }
            }
            StAXWriter writer = new StAXWriter(nss, xmlWriter);
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setXmlWriter((IXMLWriter)writer);
            this.marshal(full, ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling: " + e.getMessage(), e);
        }
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, null);
        return StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
    }
}

