/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.JSONDataSource;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class JSONMessageFormatter
implements MessageFormatter {
    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String contentType = (String)msgCtxt.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)msgCtxt.getProperty("messageType");
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        if (element instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource()) != null) {
            String jsonToWrite = this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource());
            return jsonToWrite.getBytes();
        }
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            XMLStreamWriter jsonWriter = this.getJSONWriter(bytesOut);
            element.serializeAndConsume(jsonWriter);
            jsonWriter.writeEndDocument();
            return bytesOut.toByteArray();
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new AxisFault("Mapped formatted JSON with namespaces are not supported in Axis2. Make sure that your request doesn't include namespaces or use the Badgerfish convention");
        }
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        return null;
    }

    protected XMLStreamWriter getJSONWriter(OutputStream outStream) {
        MappedNamespaceConvention mnc = new MappedNamespaceConvention();
        return new MappedXMLStreamWriter(mnc, (Writer)new OutputStreamWriter(outStream));
    }

    protected String getStringToWrite(OMDataSource dataSource) {
        if (dataSource instanceof JSONDataSource) {
            return ((JSONDataSource)dataSource).getCompleteJOSNString();
        }
        return null;
    }

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        OMElement element = msgCtxt.getEnvelope().getBody().getFirstElement();
        try {
            if (element instanceof SOAPFault && this instanceof JSONMessageFormatter) {
                SOAPFault fault = (SOAPFault)element;
                OMElementImpl element2 = new OMElementImpl("Fault", null, element.getOMFactory());
                element2.setText(fault.toString());
                element = element2;
            }
            if (element instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource()) != null) {
                String jsonToWrite = this.getStringToWrite(((OMSourcedElementImpl)element).getDataSource());
                out.write(jsonToWrite.getBytes());
            } else {
                XMLStreamWriter jsonWriter = this.getJSONWriter(out);
                element.serializeAndConsume(jsonWriter);
                jsonWriter.writeEndDocument();
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new AxisFault("Mapped formatted JSON with namespaces are not supported in Axis2. Make sure that your request doesn't include namespaces or use the Badgerfish convention");
        }
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        String httpMethod = (String)msgCtxt.getProperty("HTTP_METHOD");
        OMElement dataOut = msgCtxt.getEnvelope().getBody().getFirstElement();
        if (dataOut != null && httpMethod != null && "GET".equalsIgnoreCase(httpMethod)) {
            try {
                String jsonString;
                if (dataOut instanceof OMSourcedElementImpl && this.getStringToWrite(((OMSourcedElementImpl)dataOut).getDataSource()) != null) {
                    jsonString = this.getStringToWrite(((OMSourcedElementImpl)dataOut).getDataSource());
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    XMLStreamWriter jsonWriter = this.getJSONWriter(out);
                    dataOut.serializeAndConsume(jsonWriter);
                    jsonWriter.writeEndDocument();
                    jsonString = new String(out.toByteArray());
                }
                jsonString = URIEncoderDecoder.quoteIllegal((String)jsonString, (String)"-._~!$&()*+,;=:@?/%");
                String param = "query=" + jsonString;
                String returnURLFile = targetURL.getFile() + "?" + param;
                return new URL(targetURL.getProtocol(), targetURL.getHost(), targetURL.getPort(), returnURLFile);
            }
            catch (MalformedURLException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return targetURL;
    }
}

