/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.util.Iterator;
import org.jibx.util.SparseArrayIterator;

public class ReferenceCountMap {
    private static final double DEFAULT_FILL = 0.3;
    private static final int MINIMUM_SIZE = 63;
    private int m_entryCount;
    private int m_entryLimit;
    private int m_arraySize;
    private int m_hitOffset;
    private Object[] m_keyTable;
    private int[] m_valueTable;

    public ReferenceCountMap(int count) {
        this.m_arraySize = Math.max((int)((double)count / 0.3), 63);
        this.m_arraySize += (this.m_arraySize + 1) % 2;
        this.m_entryLimit = (int)((double)this.m_arraySize * 0.3);
        this.m_hitOffset = this.m_arraySize / 2;
        this.m_keyTable = new Object[this.m_arraySize];
        this.m_valueTable = new int[this.m_arraySize];
    }

    public ReferenceCountMap() {
        this(0);
    }

    public ReferenceCountMap(ReferenceCountMap base) {
        this.m_entryCount = base.m_entryCount;
        this.m_entryLimit = base.m_entryLimit;
        this.m_arraySize = base.m_arraySize;
        this.m_hitOffset = base.m_hitOffset;
        this.m_keyTable = new Object[this.m_arraySize];
        System.arraycopy(base.m_keyTable, 0, this.m_keyTable, 0, this.m_arraySize);
        this.m_valueTable = new int[this.m_arraySize];
        System.arraycopy(base.m_valueTable, 0, this.m_valueTable, 0, this.m_arraySize);
    }

    private final int stepSlot(int slot) {
        return (slot + this.m_hitOffset) % this.m_arraySize;
    }

    private final int freeSlot(int slot) {
        while (this.m_keyTable[slot] != null) {
            slot = this.stepSlot(slot);
        }
        return slot;
    }

    private final int standardSlot(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.m_arraySize;
    }

    private int standardFind(Object key) {
        int slot = this.standardSlot(key);
        while (this.m_keyTable[slot] != null) {
            if (this.m_keyTable[slot].equals(key)) {
                return slot;
            }
            slot = this.stepSlot(slot);
        }
        return -slot - 1;
    }

    private boolean reinsert(int slot) {
        Object key = this.m_keyTable[slot];
        this.m_keyTable[slot] = null;
        return this.assignSlot(key, this.m_valueTable[slot]) != slot;
    }

    private void internalRemove(int slot) {
        this.m_keyTable[slot] = null;
        --this.m_entryCount;
        while (this.m_keyTable[slot = this.stepSlot(slot)] != null) {
            this.reinsert(slot);
        }
    }

    private void restructure(Object[] keys, int[] values) {
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            this.assignSlot(keys[i], values[i]);
        }
    }

    private int assignSlot(Object key, int value) {
        int offset = this.freeSlot(this.standardSlot(key));
        this.m_keyTable[offset] = key;
        this.m_valueTable[offset] = value;
        return offset;
    }

    public int incrementCount(Object key) {
        int offset;
        if (key == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        int min = this.m_entryCount + 1;
        if (min > this.m_entryLimit) {
            int size = this.m_arraySize;
            int limit = this.m_entryLimit;
            while (limit < min) {
                size = size * 2 + 1;
                limit = (int)((double)size * 0.3);
            }
            this.m_arraySize = size;
            this.m_entryLimit = limit;
            this.m_hitOffset = size / 2;
            Object[] keys = this.m_keyTable;
            this.m_keyTable = new Object[this.m_arraySize];
            int[] values = this.m_valueTable;
            this.m_valueTable = new int[this.m_arraySize];
            this.restructure(keys, values);
        }
        if ((offset = this.standardFind(key)) >= 0) {
            int n = offset;
            int n2 = this.m_valueTable[n] + 1;
            this.m_valueTable[n] = n2;
            return n2;
        }
        ++this.m_entryCount;
        offset = -offset - 1;
        this.m_keyTable[offset] = key;
        this.m_valueTable[offset] = 1;
        return 1;
    }

    public final int getCount(Object key) {
        int slot = this.standardFind(key);
        if (slot >= 0) {
            return this.m_valueTable[slot];
        }
        return 0;
    }

    public int size() {
        return this.m_entryCount;
    }

    public Iterator iterator() {
        return SparseArrayIterator.buildIterator(this.m_keyTable);
    }

    public Object[] keyArray() {
        Object[] keys = new Object[this.m_entryCount];
        int fill = 0;
        for (int i = 0; i < this.m_arraySize; ++i) {
            if (this.m_keyTable[i] == null) continue;
            keys[fill++] = this.m_keyTable[i];
        }
        return keys;
    }

    public Object clone() {
        return new ReferenceCountMap(this);
    }

    public void clear() {
        for (int i = 0; i < this.m_keyTable.length; ++i) {
            if (this.m_keyTable[i] == null) continue;
            this.m_keyTable[i] = null;
            this.m_valueTable[i] = 0;
        }
    }
}

