/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final int GLOBAL_NUM = 11;
    private String fName = null;
    private String fTargetNamespace = null;
    private short fDerivedBy = (short)2;
    private short fFinal = 0;
    private short fBlock = 0;
    private short fContentType = 0;
    private XSTypeDefinition fBaseType = null;
    private XSAttributeGroupDecl fAttrGrp = null;
    private XSSimpleType fXSSimpleType = null;
    private XSParticleDecl fParticle = null;
    private boolean fIsAbstract = false;
    private XSComplexTypeDecl fComplexTypeDecl = null;
    private XSAnnotationImpl[] fAnnotations = null;
    private XSParticleDecl fEmptyParticle = null;
    private Object[] fGlobalStore = null;
    private int fGlobalStorePos = 0;
    private static final boolean DEBUG = false;
    private SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDComplexTypeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSComplexTypeDecl traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string = this.genAnonTypeName(element);
        this.contentBackup();
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar);
        this.contentRestore();
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        xSComplexTypeDecl.setIsAnonymous();
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    XSComplexTypeDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        this.contentBackup();
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar);
        this.contentRestore();
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME}, element);
        } else {
            schemaGrammar.addGlobalTypeDecl(xSComplexTypeDecl);
        }
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element element, String string, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        this.fComplexTypeDecl = new XSComplexTypeDecl();
        this.fAttrGrp = new XSAttributeGroupDecl();
        Boolean bl = (Boolean)objectArray[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean bl2 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        XInt xInt2 = (XInt)objectArray[XSAttributeChecker.ATTIDX_FINAL];
        this.fName = string;
        this.fComplexTypeDecl.setName(this.fName);
        this.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
        this.fBlock = xInt == null ? xSDocumentInfo.fBlockDefault : xInt.shortValue();
        this.fFinal = xInt2 == null ? xSDocumentInfo.fFinalDefault : xInt2.shortValue();
        this.fBlock = (short)(this.fBlock & 3);
        this.fFinal = (short)(this.fFinal & 3);
        if (bl != null && bl.booleanValue()) {
            this.fIsAbstract = true;
        }
        Element element2 = null;
        try {
            element2 = DOMUtil.getFirstChildElement(element);
            if (element2 != null) {
                if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.addAnnotation(this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo));
                    element2 = DOMUtil.getNextSiblingElement(element2);
                }
                if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
                }
            }
            if (element2 == null) {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl2, false, xSDocumentInfo, schemaGrammar);
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(element2, xSDocumentInfo, schemaGrammar);
                Element element3 = DOMUtil.getNextSiblingElement(element2);
                if (element3 != null) {
                    String string2 = DOMUtil.getLocalName(element3);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string2}, element3);
                }
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(element2, bl2, xSDocumentInfo, schemaGrammar);
                Element element4 = DOMUtil.getNextSiblingElement(element2);
                if (element4 != null) {
                    String string3 = DOMUtil.getLocalName(element4);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string3}, element4);
                }
            } else {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl2, false, xSDocumentInfo, schemaGrammar);
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            this.handleComplexTypeError(complexTypeRecoverableError.getMessage(), complexTypeRecoverableError.errorSubstText, complexTypeRecoverableError.errorElem);
        }
        this.fComplexTypeDecl.setValues(this.fName, this.fTargetNamespace, this.fBaseType, this.fDerivedBy, this.fFinal, this.fBlock, this.fContentType, this.fIsAbstract, this.fAttrGrp, this.fXSSimpleType, this.fParticle, new XSObjectListImpl(this.fAnnotations, this.fAnnotations == null ? 0 : this.fAnnotations.length));
        return this.fComplexTypeDecl;
    }

    private void traverseSimpleContent(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        this.fContentType = 1;
        this.fParticle = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.addAnnotation(this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo));
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.2", new Object[]{this.fName, SchemaSymbols.ELT_SIMPLECONTENT}, element);
        }
        String string = DOMUtil.getLocalName(element2);
        if (string.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            String string2 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string2}, element3);
        }
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray2[XSAttributeChecker.ATTIDX_BASE];
        if (qName == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-att-must-appear", new Object[]{string, "base"}, element2);
        }
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDefinition == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw new ComplexTypeRecoverableError();
        }
        this.fBaseType = xSTypeDefinition;
        XSSimpleType xSSimpleType = null;
        XSComplexTypeDecl xSComplexTypeDecl = null;
        short s = 0;
        if (xSTypeDefinition.getTypeCategory() == 15) {
            xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            s = xSComplexTypeDecl.getFinal();
            if (xSComplexTypeDecl.getContentType() == 1) {
                xSSimpleType = (XSSimpleType)xSComplexTypeDecl.getSimpleType();
            } else if (this.fDerivedBy != 2 || xSComplexTypeDecl.getContentType() != 3 || !((XSParticleDecl)xSComplexTypeDecl.getParticle()).emptiable()) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("src-ct.2.1", new Object[]{this.fName, xSComplexTypeDecl.getName()}, element2);
            }
        } else {
            xSSimpleType = (XSSimpleType)xSTypeDefinition;
            if (this.fDerivedBy == 2) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("src-ct.2.1", new Object[]{this.fName, xSSimpleType.getName()}, element2);
            }
            s = xSSimpleType.getFinal();
        }
        if ((s & this.fDerivedBy) != 0) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            String string3 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string3, new Object[]{this.fName, this.fBaseType.getName()}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.addAnnotation(this.traverseAnnotationDecl(element2, objectArray2, false, xSDocumentInfo));
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        if (this.fDerivedBy == 2) {
            Object object;
            Object object2;
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                object2 = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
                if (object2 == null) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError();
                }
                if (xSSimpleType != null && !XSConstraints.checkSimpleDerivationOk((XSSimpleType)object2, xSSimpleType, xSSimpleType.getFinal())) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.2.2.1", new Object[]{this.fName, object2.getName(), xSSimpleType.getName()}, element2);
                }
                xSSimpleType = object2;
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (xSSimpleType == null) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("src-ct.2.2", new Object[]{this.fName}, element2);
            }
            object2 = null;
            XSFacets xSFacets = null;
            short s2 = 0;
            short s3 = 0;
            if (element2 != null) {
                object = this.traverseFacets(element2, xSSimpleType, xSDocumentInfo);
                object2 = object.nodeAfterFacets;
                xSFacets = object.facetdata;
                s2 = object.fPresentFacets;
                s3 = object.fFixedFacets;
            }
            this.fXSSimpleType = this.schemaFactory.createTypeRestriction(null, xSDocumentInfo.fTargetNamespace, (short)0, xSSimpleType, null);
            try {
                this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                this.fXSSimpleType.applyFacets(xSFacets, s2, s3, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                this.reportSchemaError(invalidDatatypeFacetException.getKey(), invalidDatatypeFacetException.getArgs(), element2);
            }
            if (object2 != null) {
                if (!this.isAttrOrAttrGroup((Element)object2)) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object2)}, (Element)object2);
                }
                object = this.traverseAttrsAndAttrGrps((Element)object2, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
                if (object != null) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object)}, (Element)object);
                }
            }
            try {
                this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, false, element);
            }
            catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw complexTypeRecoverableError;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            object = this.fAttrGrp.validRestrictionOf(this.fName, xSComplexTypeDecl.getAttrGrp());
            if (object != null) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError((String)object[((Object[])object).length - 1], (Object[])object, (Element)object2);
            }
        } else {
            this.fXSSimpleType = xSSimpleType;
            if (element2 != null) {
                Element element4 = element2;
                if (!this.isAttrOrAttrGroup(element4)) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(element4)}, element4);
                }
                Element element5 = this.traverseAttrsAndAttrGrps(element4, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
                if (element5 != null) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(element5)}, element5);
                }
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (xSComplexTypeDecl != null) {
                try {
                    this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, true, element);
                }
                catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw complexTypeRecoverableError;
                }
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
    }

    private void traverseComplexContent(Element element, boolean bl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        boolean bl2 = bl;
        Boolean bl3 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        if (bl3 != null) {
            bl2 = bl3;
        }
        this.fXSSimpleType = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.addAnnotation(this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo));
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.2", new Object[]{this.fName, SchemaSymbols.ELT_COMPLEXCONTENT}, element);
        }
        String string = DOMUtil.getLocalName(element2);
        if (string.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            String string2 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, string2}, element3);
        }
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray2[XSAttributeChecker.ATTIDX_BASE];
        if (qName == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("s4s-att-must-appear", new Object[]{string, "base"}, element2);
        }
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDefinition == null) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw new ComplexTypeRecoverableError();
        }
        if (!(xSTypeDefinition instanceof XSComplexTypeDecl)) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{this.fName, xSTypeDefinition.getName()}, element2);
        }
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
        this.fBaseType = xSComplexTypeDecl;
        if ((xSComplexTypeDecl.getFinal() & this.fDerivedBy) != 0) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            String string3 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string3, new Object[]{this.fName, this.fBaseType.getName()}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.addAnnotation(this.traverseAnnotationDecl(element2, objectArray2, false, xSDocumentInfo));
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        try {
            this.processComplexContent(element2, bl2, true, xSDocumentInfo, schemaGrammar);
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            throw complexTypeRecoverableError;
        }
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (this.fDerivedBy == 2) {
            Object[] objectArray3;
            if (this.fContentType == 3 && xSComplexTypeDecl.getContentType() != 3) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.4.1.2", new Object[]{this.fName, xSComplexTypeDecl.getName()}, element2);
            }
            try {
                this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, false, element2);
            }
            catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw complexTypeRecoverableError;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            if (xSComplexTypeDecl != SchemaGrammar.fAnyType && (objectArray3 = this.fAttrGrp.validRestrictionOf(this.fName, xSComplexTypeDecl.getAttrGrp())) != null) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw new ComplexTypeRecoverableError((String)objectArray3[objectArray3.length - 1], objectArray3, element2);
            }
        } else {
            if (this.fParticle == null) {
                this.fContentType = xSComplexTypeDecl.getContentType();
                this.fXSSimpleType = (XSSimpleType)xSComplexTypeDecl.getSimpleType();
                this.fParticle = xSParticleDecl;
            } else if (xSComplexTypeDecl.getContentType() != 0) {
                if (this.fContentType == 2 && xSComplexTypeDecl.getContentType() != 2) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.1.a", new Object[]{this.fName}, element2);
                }
                if (this.fContentType == 3 && xSComplexTypeDecl.getContentType() != 3) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.1.b", new Object[]{this.fName}, element2);
                }
                if (this.fParticle.fType == 3 && ((XSModelGroupImpl)this.fParticle.fValue).fCompositor == 103 || ((XSParticleDecl)xSComplexTypeDecl.getParticle()).fType == 3 && ((XSModelGroupImpl)((XSParticleDecl)xSComplexTypeDecl.getParticle()).fValue).fCompositor == 103) {
                    this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                    this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                    throw new ComplexTypeRecoverableError("cos-all-limited.1.2", new Object[0], element2);
                }
                XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
                xSModelGroupImpl.fCompositor = (short)102;
                xSModelGroupImpl.fParticleCount = 2;
                xSModelGroupImpl.fParticles = new XSParticleDecl[2];
                xSModelGroupImpl.fParticles[0] = (XSParticleDecl)xSComplexTypeDecl.getParticle();
                xSModelGroupImpl.fParticles[1] = this.fParticle;
                XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
                xSParticleDecl2.fType = (short)3;
                xSParticleDecl2.fValue = xSModelGroupImpl;
                this.fParticle = xSParticleDecl2;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            try {
                this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, true, element2);
            }
            catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
                this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
                this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
                throw complexTypeRecoverableError;
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
    }

    private void mergeAttributes(XSAttributeGroupDecl xSAttributeGroupDecl, XSAttributeGroupDecl xSAttributeGroupDecl2, String string, boolean bl, Element element) throws ComplexTypeRecoverableError {
        XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
        Object var7_7 = null;
        XSAttributeUseImpl xSAttributeUseImpl = null;
        int n = xSObjectList.getLength();
        int n2 = 0;
        while (n2 < n) {
            xSAttributeUseImpl = (XSAttributeUseImpl)xSObjectList.item(n2);
            XSAttributeUse xSAttributeUse = xSAttributeGroupDecl2.getAttributeUse(xSAttributeUseImpl.fAttrDecl.getNamespace(), xSAttributeUseImpl.fAttrDecl.getName());
            if (xSAttributeUse == null) {
                String string2 = xSAttributeGroupDecl2.addAttributeUse(xSAttributeUseImpl);
                if (string2 != null) {
                    throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{string, string2, xSAttributeUseImpl.fAttrDecl.getName()}, element);
                }
            } else if (bl) {
                throw new ComplexTypeRecoverableError("ct-props-correct.4", new Object[]{string, xSAttributeUseImpl.fAttrDecl.getName()}, element);
            }
            ++n2;
        }
        if (bl) {
            if (xSAttributeGroupDecl2.fAttributeWC == null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl.fAttributeWC;
            } else if (xSAttributeGroupDecl.fAttributeWC != null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl2.fAttributeWC.performUnionWith(xSAttributeGroupDecl.fAttributeWC, xSAttributeGroupDecl2.fAttributeWC.fProcessContents);
            }
        }
    }

    private void processComplexContent(Element element, boolean bl, boolean bl2, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object object;
        Element element2 = null;
        XSParticleDecl xSParticleDecl = null;
        boolean bl3 = false;
        if (element != null) {
            object = DOMUtil.getLocalName(element);
            if (((String)object).equals(SchemaSymbols.ELT_GROUP)) {
                xSParticleDecl = this.fSchemaHandler.fGroupTraverser.traverseLocal(element, xSDocumentInfo, schemaGrammar);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_SEQUENCE)) {
                xSParticleDecl = this.traverseSequence(element, xSDocumentInfo, schemaGrammar, 0, this.fComplexTypeDecl);
                if (xSParticleDecl != null) {
                    XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
                    if (xSModelGroupImpl.fParticleCount == 0) {
                        bl3 = true;
                    }
                }
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_CHOICE)) {
                xSParticleDecl = this.traverseChoice(element, xSDocumentInfo, schemaGrammar, 0, this.fComplexTypeDecl);
                if (xSParticleDecl != null && xSParticleDecl.fMinOccurs == 0) {
                    XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
                    if (xSModelGroupImpl.fParticleCount == 0) {
                        bl3 = true;
                    }
                }
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_ALL)) {
                xSParticleDecl = this.traverseAll(element, xSDocumentInfo, schemaGrammar, 8, this.fComplexTypeDecl);
                if (xSParticleDecl != null) {
                    XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
                    if (xSModelGroupImpl.fParticleCount == 0) {
                        bl3 = true;
                    }
                }
                element2 = DOMUtil.getNextSiblingElement(element);
            } else {
                element2 = element;
            }
        }
        if (bl3) {
            object = DOMUtil.getFirstChildElement(element);
            if (object != null && DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                object = DOMUtil.getNextSiblingElement((Node)object);
            }
            if (object == null) {
                xSParticleDecl = null;
            }
        }
        if (xSParticleDecl == null && bl) {
            if (this.fEmptyParticle == null) {
                object = new XSModelGroupImpl();
                ((XSModelGroupImpl)object).fCompositor = (short)102;
                ((XSModelGroupImpl)object).fParticleCount = 0;
                ((XSModelGroupImpl)object).fParticles = null;
                this.fEmptyParticle = new XSParticleDecl();
                this.fEmptyParticle.fType = (short)3;
                this.fEmptyParticle.fValue = object;
            }
            xSParticleDecl = this.fEmptyParticle;
        }
        this.fParticle = xSParticleDecl;
        this.fContentType = this.fParticle == null ? (short)0 : (bl ? (short)3 : (short)2);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(element2)}, element2);
            }
            object = this.traverseAttrsAndAttrGrps(element2, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
            if (object != null) {
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object)}, (Element)object);
            }
            if (!bl2) {
                this.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = DOMUtil.getLocalName(element);
        return string.equals(SchemaSymbols.ELT_ATTRIBUTE) || string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || string.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseSimpleContentDecl(Element element) {
    }

    private void traverseComplexContentDecl(Element element, boolean bl) {
    }

    private String genAnonTypeName(Element element) {
        Element element2 = DOMUtil.getParent(element);
        String string = "#AnonType_";
        while (element2 != null && element2 != DOMUtil.getRoot(DOMUtil.getDocument(element2))) {
            string = string + element2.getAttribute(SchemaSymbols.ATT_NAME);
            element2 = DOMUtil.getParent(element2);
        }
        return string;
    }

    private void handleComplexTypeError(String string, Object[] objectArray, Element element) {
        if (string != null) {
            this.reportSchemaError(string, objectArray, element);
        }
        this.fBaseType = SchemaGrammar.fAnyType;
        this.fContentType = (short)3;
        this.fParticle = this.getErrorContent();
        this.fAttrGrp.fAttributeWC = this.getErrorWildcard();
    }

    private XSParticleDecl getErrorContent() {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fType = (short)2;
        xSParticleDecl.fValue = this.getErrorWildcard();
        xSParticleDecl.fMinOccurs = 0;
        xSParticleDecl.fMaxOccurs = -1;
        XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
        xSModelGroupImpl.fCompositor = (short)102;
        xSModelGroupImpl.fParticleCount = 1;
        xSModelGroupImpl.fParticles = new XSParticleDecl[1];
        xSModelGroupImpl.fParticles[0] = xSParticleDecl;
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl2.fType = (short)3;
        xSParticleDecl2.fValue = xSModelGroupImpl;
        return xSParticleDecl2;
    }

    private XSWildcardDecl getErrorWildcard() {
        XSWildcardDecl xSWildcardDecl = new XSWildcardDecl();
        xSWildcardDecl.fProcessContents = (short)2;
        return xSWildcardDecl;
    }

    private void contentBackup() {
        if (this.fGlobalStore == null) {
            this.fGlobalStore = new Object[11];
            this.fGlobalStorePos = 0;
        }
        if (this.fGlobalStorePos == this.fGlobalStore.length) {
            Object[] objectArray = new Object[this.fGlobalStorePos + 11];
            System.arraycopy(this.fGlobalStore, 0, objectArray, 0, this.fGlobalStorePos);
            this.fGlobalStore = objectArray;
        }
        this.fGlobalStore[this.fGlobalStorePos++] = this.fComplexTypeDecl;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAbstract ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fName;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fTargetNamespace;
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fDerivedBy << 16) + this.fFinal);
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fBlock << 16) + this.fContentType);
        this.fGlobalStore[this.fGlobalStorePos++] = this.fBaseType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAttrGrp;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fParticle;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fXSSimpleType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAnnotations;
    }

    private void contentRestore() {
        this.fAnnotations = (XSAnnotationImpl[])this.fGlobalStore[--this.fGlobalStorePos];
        this.fXSSimpleType = (XSSimpleType)this.fGlobalStore[--this.fGlobalStorePos];
        this.fParticle = (XSParticleDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAttrGrp = (XSAttributeGroupDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBaseType = (XSTypeDefinition)this.fGlobalStore[--this.fGlobalStorePos];
        int n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBlock = (short)(n >> 16);
        this.fContentType = (short)n;
        n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fDerivedBy = (short)(n >> 16);
        this.fFinal = (short)n;
        this.fTargetNamespace = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fName = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAbstract = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
        this.fComplexTypeDecl = (XSComplexTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
    }

    private void addAnnotation(XSAnnotationImpl xSAnnotationImpl) {
        if (xSAnnotationImpl == null) {
            return;
        }
        if (this.fAnnotations == null) {
            this.fAnnotations = new XSAnnotationImpl[1];
        } else {
            XSAnnotationImpl[] xSAnnotationImplArray = new XSAnnotationImpl[this.fAnnotations.length + 1];
            System.arraycopy(this.fAnnotations, 0, xSAnnotationImplArray, 0, this.fAnnotations.length);
            this.fAnnotations = xSAnnotationImplArray;
        }
        this.fAnnotations[this.fAnnotations.length - 1] = xSAnnotationImpl;
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;
        Element errorElem = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string, Object[] objectArray, Element element) {
            super(string);
            this.errorSubstText = objectArray;
            this.errorElem = element;
        }
    }
}

