/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.resolver;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.util.StringUtils;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public abstract class SchemaResolverAdapter
implements URIResolver {
    private org.apache.woden.resolver.URIResolver fActualResolver;
    protected XMLElement fContextElement;

    public SchemaResolverAdapter(org.apache.woden.resolver.URIResolver actualResolver, XMLElement contextElement) {
        this.fActualResolver = actualResolver;
        this.fContextElement = contextElement;
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        URI uri = null;
        try {
            URI resolvedBaseUri = this.fActualResolver.resolveURI(new URI(baseUri));
            uri = this.buildUri(targetNamespace, schemaLocation, resolvedBaseUri == null ? baseUri : resolvedBaseUri.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        URI resolved = null;
        try {
            resolved = this.fActualResolver.resolveURI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InputSource iSource = new InputSource(resolved != null ? resolved.toString() : uri.toString());
        String systemId = iSource.getSystemId();
        String fragId = null;
        int i = systemId.indexOf("#");
        if (i > -1) {
            fragId = systemId.substring(i);
            iSource.setByteStream(this.resolveFragId(fragId));
        }
        return iSource;
    }

    protected abstract InputStream resolveFragId(String var1);

    private URI buildUri(String targetNamespace, String schemaLocation, String baseUri) throws URISyntaxException, MalformedURLException {
        if (baseUri != null) {
            URL ctxUrl = new URL(baseUri);
            URL schemaUrl = StringUtils.getURL(ctxUrl, schemaLocation);
            URI uri = new URI(schemaUrl.toString());
            return uri;
        }
        return new URI(schemaLocation);
    }
}

