/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TryCatchFinallyPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TryCatchFinallyPrinter();

    protected TryCatchFinallyPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("try", 133);
        this.printCommentsAfter(node, false, false, out);
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 12: {
                    PrinterFactory.create(child, out).print(child, out);
                    break;
                }
                case 135: {
                    this.printCatch(child, out);
                    break;
                }
                case 134: {
                    this.printFinallyPart(child, out);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal type -- " + child);
                }
            }
            child = child.getNextSibling();
        }
        out.last = 8;
    }

    private void printCatch(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 175);
        }
        out.print("catch", 135);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 135);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen, out).print(lparen, out);
        AST parameters = lparen.getNextSibling();
        PrinterFactory.create(parameters, out).print(parameters, out);
        AST rparen = parameters.getNextSibling();
        PrinterFactory.create(rparen, out).print(rparen, out);
        JavaNode body = (JavaNode)rparen.getNextSibling();
        PrinterFactory.create(body, out).print(body, out);
    }

    private void printFinallyPart(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 175);
        }
        out.print("finally", 134);
        this.printCommentsAfter(node, out);
        JavaNode body = (JavaNode)node.getFirstChild();
        PrinterFactory.create(body, out).print(body, out);
    }
}

