/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.core.NOOPResponse;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.AbstractHandler;
import org.icefaces.push.server.Handler;
import org.icefaces.push.server.SequenceNumbers;
import org.icefaces.push.server.SessionManager;
import org.icefaces.push.server.UpdatedViewsResponseHandler;

public class ReceiveUpdatedViewsHandler
extends AbstractHandler
implements Handler,
Runnable {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_PROCESSING_REQUEST = 1;
    private static final int STATE_WAITING_FOR_RESPONSE = 2;
    private static final int STATE_RESPONSE_IS_READY = 3;
    private static final int STATE_DONE = 4;
    private static final Log LOG = LogFactory.getLog((Class)ReceiveUpdatedViewsHandler.class);
    private static final ResponseHandler CLOSE_RESPONSE_HANDLER = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setStatus(200);
            response.setHeader("Content-Length", 0);
            response.setHeader("X-Connection", "close");
        }
    };
    private final long blockingConnectionTimeout;
    private final SessionManager sessionManager;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private Set iceFacesIdSet;
    private ScheduledFuture scheduledFuture;
    private List updatedViewsList;
    private int state = 0;

    public ReceiveUpdatedViewsHandler(Request request, Set iceFacesIdSet, SessionManager sessionManager, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration) {
        super(request);
        this.iceFacesIdSet = iceFacesIdSet;
        this.sessionManager = sessionManager;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.blockingConnectionTimeout = configuration.getAttributeAsLong("blockingConnectionTimeout", 90000L);
    }

    public void respondWith(Request request, List updatedViewsList) {
        block2: {
            try {
                request.respondWith((ResponseHandler)new UpdatedViewsResponseHandler(request, updatedViewsList));
            }
            catch (Exception exception) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An error occurred while trying to response with: 200 OK!", (Throwable)exception);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        switch (this.state) {
            case 0: {
                if (ReceiveUpdatedViewsHandler.LOG.isTraceEnabled()) {
                    ReceiveUpdatedViewsHandler.LOG.trace((Object)"State: Uninitialized");
                }
                this.state = 1;
            }
            case 1: {
                if (ReceiveUpdatedViewsHandler.LOG.isTraceEnabled()) {
                    ReceiveUpdatedViewsHandler.LOG.trace((Object)"State: Processing Request");
                }
                if ((_receiveUpdatedViewsHandler = (ReceiveUpdatedViewsHandler)this.sessionManager.getRequestManager().pull(this.iceFacesIdSet)) == null) ** GOTO lbl23
                if (_receiveUpdatedViewsHandler.scheduledFuture != null) {
                    _receiveUpdatedViewsHandler.scheduledFuture.cancel(false);
                    _receiveUpdatedViewsHandler.scheduledFuture = null;
                }
                try {
                    if (ReceiveUpdatedViewsHandler.LOG.isDebugEnabled()) {
                        ReceiveUpdatedViewsHandler.LOG.debug((Object)("Send Close response to previous request: ICEfaces IDs [" + this.iceFacesIdSet + "], " + "Sequence Numbers [" + new SequenceNumbers(this.request.getHeaderAsStrings("X-Window-Cookie")) + "]"));
                    }
                    _receiveUpdatedViewsHandler.request.respondWith(ReceiveUpdatedViewsHandler.CLOSE_RESPONSE_HANDLER);
                }
                catch (Exception exception) {
                    if (!ReceiveUpdatedViewsHandler.LOG.isErrorEnabled()) ** GOTO lbl22
                    ReceiveUpdatedViewsHandler.LOG.error((Object)"An error occurred while trying to response with: 200 OK!", (Throwable)exception);
                }
lbl22:
                // 3 sources

                _receiveUpdatedViewsHandler.state = 4;
lbl23:
                // 2 sources

                this.state = 2;
            }
            case 2: {
                if (ReceiveUpdatedViewsHandler.LOG.isTraceEnabled()) {
                    ReceiveUpdatedViewsHandler.LOG.trace((Object)"State: Waiting for Response");
                }
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(false);
                    this.scheduledFuture = null;
                }
                if (!this.sessionManager.isValid(this.iceFacesIdSet) || !this.sessionManager.hasViews(this.iceFacesIdSet)) ** GOTO lbl39
                this.updatedViewsList = this.sessionManager.getUpdatedViewsManager().pull(this.iceFacesIdSet, new SequenceNumbers(this.request.getHeaderAsStrings("X-Window-Cookie")));
                if (this.updatedViewsList == null || this.updatedViewsList.isEmpty()) {
                    this.sessionManager.getRequestManager().push(this.iceFacesIdSet, this);
                    this.scheduledFuture = this.scheduledThreadPoolExecutor.schedule((Runnable)new BlockingConnectionTimeoutTask(this.iceFacesIdSet, this.sessionManager), this.blockingConnectionTimeout, TimeUnit.MILLISECONDS);
                    return;
                }
                this.state = 3;
                ** GOTO lbl49
lbl39:
                // 1 sources

                try {
                    if (ReceiveUpdatedViewsHandler.LOG.isDebugEnabled()) {
                        ReceiveUpdatedViewsHandler.LOG.debug((Object)("Send Close response to request: ICEfaces IDs [" + this.iceFacesIdSet + "], " + "Sequence Numbers [" + new SequenceNumbers(this.request.getHeaderAsStrings("X-Window-Cookie")) + "]"));
                    }
                    this.request.respondWith(ReceiveUpdatedViewsHandler.CLOSE_RESPONSE_HANDLER);
                }
                catch (Exception exception) {
                    if (!ReceiveUpdatedViewsHandler.LOG.isErrorEnabled()) ** GOTO lbl47
                    ReceiveUpdatedViewsHandler.LOG.error((Object)"An error occurred while trying to responde with: 200 OK (close)", (Throwable)exception);
                }
lbl47:
                // 3 sources

                this.state = 4;
                return;
            }
lbl49:
            // 2 sources

            case 3: {
                if (ReceiveUpdatedViewsHandler.LOG.isTraceEnabled()) {
                    ReceiveUpdatedViewsHandler.LOG.trace((Object)"State: Response is Ready");
                }
                if (ReceiveUpdatedViewsHandler.LOG.isDebugEnabled()) {
                    ReceiveUpdatedViewsHandler.LOG.debug((Object)("Send Updated Views response to request: ICEfaces IDs [" + this.iceFacesIdSet + "], " + "Sequence Numbers [" + new SequenceNumbers(this.request.getHeaderAsStrings("X-Window-Cookie")) + "]"));
                }
                this.respondWith(this.request, this.updatedViewsList);
                this.state = 4;
            }
            case 4: {
                if (!ReceiveUpdatedViewsHandler.LOG.isTraceEnabled()) break;
                ReceiveUpdatedViewsHandler.LOG.trace((Object)"State: Done");
                break;
            }
        }
    }

    private static class BlockingConnectionTimeoutTask
    implements Runnable {
        private final Set iceFacesIdSet;
        private final SessionManager sessionManager;
        private final Thread originatingThread = Thread.currentThread();

        public BlockingConnectionTimeoutTask(Set iceFacesIdSet, SessionManager sessionManager) {
            this.iceFacesIdSet = iceFacesIdSet;
            this.sessionManager = sessionManager;
        }

        public void run() {
            ReceiveUpdatedViewsHandler _receiveUpdatedViewsHandler = (ReceiveUpdatedViewsHandler)this.sessionManager.getRequestManager().pull(this.iceFacesIdSet);
            if (_receiveUpdatedViewsHandler != null) {
                block4: {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Send Noop response to request: ICEfaces IDs [" + this.iceFacesIdSet + "], " + "Sequence Numbers [" + new SequenceNumbers(_receiveUpdatedViewsHandler.request.getHeaderAsStrings("X-Window-Cookie")) + "], " + "Originating Thread [" + this.originatingThread + "]"));
                        }
                        _receiveUpdatedViewsHandler.request.respondWith(NOOPResponse.Handler);
                    }
                    catch (Exception exception) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error((Object)"An error occurred while trying to responde with: 200 OK (noop)", (Throwable)exception);
                    }
                }
                _receiveUpdatedViewsHandler.state = 4;
            }
        }
    }
}

