/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.phaseresolver;

import java.util.List;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseException;

public class PhaseHolder {
    private List phaseList;

    public PhaseHolder() {
    }

    public PhaseHolder(List phases) {
        this.phaseList = phases;
    }

    public void addHandler(HandlerDescription handlerDesc) throws PhaseException {
        PhaseRule rule = handlerDesc.getRules();
        rule.validate();
        String phaseName = rule.getPhaseName();
        if ("*".equals(phaseName)) {
            handlerDesc.getRules().setBefore("");
            handlerDesc.getRules().setAfter("");
            for (int i = 0; i < this.phaseList.size(); ++i) {
                Phase phase = (Phase)this.phaseList.get(i);
                phase.addHandler(handlerDesc);
            }
        } else if (this.phaseExists(phaseName)) {
            this.getPhase(phaseName).addHandler(handlerDesc);
        } else {
            throw new PhaseException(Messages.getMessage("invalidphase", phaseName, handlerDesc.getName()));
        }
    }

    private Phase getPhase(String phaseName) {
        for (int i = 0; i < this.phaseList.size(); ++i) {
            Phase phase = (Phase)this.phaseList.get(i);
            if (!phase.getPhaseName().equals(phaseName)) continue;
            return phase;
        }
        return null;
    }

    private boolean phaseExists(String phaseName) {
        for (int i = 0; i < this.phaseList.size(); ++i) {
            Phase phase = (Phase)this.phaseList.get(i);
            if (!phase.getPhaseName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }
}

