/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelpopup;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.ext.renderkit.GroupRenderer;
import com.icesoft.faces.component.panelpopup.PanelPopup;
import com.icesoft.faces.component.paneltooltip.PanelTooltip;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PanelPopupRenderer
extends GroupRenderer {
    private static Log log = LogFactory.getLog((Class)PanelPopupRenderer.class);
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU_JS_EVENTS = LocalEffectEncoder.maskEvents((String[])ExtendedAttributeConstants.getAttributes(58));
    private static final String[] PASSTHRU = ExtendedAttributeConstants.getAttributes(58, new String[][]{PASSTHRU_EXCLUDE, PASSTHRU_JS_EVENTS});

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PanelPopupRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, (Class)PanelPopup.class);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        String headerClass = (String)uiComponent.getAttributes().get("headerClass");
        String bodyClass = (String)uiComponent.getAttributes().get("bodyClass");
        Boolean resizable = null;
        Boolean modal = (Boolean)uiComponent.getAttributes().get("modal");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Value of modal is [" + modal + "]"));
        }
        Boolean visible = (Boolean)uiComponent.getAttributes().get("visible");
        String dndType = this.getDndType(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        PanelPopup panelPopup = (PanelPopup)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            String script;
            Element rootDiv = domContext.createRootElement("div");
            PanelPopupRenderer.setRootElementId((FacesContext)facesContext, (Element)rootDiv, (UIComponent)uiComponent);
            rootDiv.setAttribute("name", clientId);
            if (uiComponent instanceof PanelTooltip && ((PanelTooltip)uiComponent).isDynamic() && !((PanelTooltip)uiComponent).isVisible()) {
                rootDiv.setAttribute("style", "display:none;");
                domContext.stepOver();
                return;
            }
            Element table = domContext.createElement("table");
            table.setAttribute("cellpadding", "0");
            table.setAttribute("cellspacing", "0");
            rootDiv.appendChild(table);
            if (dndType != null) {
                Element statusField = this.createHiddenField(domContext, facesContext, uiComponent, "status");
                rootDiv.appendChild(statusField);
                Element targetID = this.createHiddenField(domContext, facesContext, uiComponent, "dropID");
                rootDiv.appendChild(targetID);
            }
            if ((script = this.modalJavascript(uiComponent, modal, visible, facesContext, clientId)) != null) {
                Element scriptEle = domContext.createElement("script");
                scriptEle.setAttribute("language", "JavaScript");
                scriptEle.setAttribute("id", ClientIdPool.get((String)(clientId + "script")));
                scriptEle.setAttribute("type", "text/javascript");
                Text node = domContext.createTextNode(script);
                scriptEle.appendChild(node);
                rootDiv.appendChild(scriptEle);
            }
        }
        Element root = (Element)domContext.getRootNode();
        try {
            root.setAttribute("class", styleClass);
        }
        catch (Exception e) {
            log.error((Object)"Error rendering Modal Panel Popup ", (Throwable)e);
        }
        JavascriptContext.fireEffect((UIComponent)uiComponent, (FacesContext)facesContext);
        NodeList tables = root.getElementsByTagName("table");
        Element table = (Element)tables.item(0);
        DOMContext.removeChildrenByTagName((Element)table, (String)"tr");
        this.doPassThru(facesContext, uiComponent, root);
        String handleId = null;
        if (panelPopup.getHeader() != null) {
            Element headerTr = domContext.createElement("tr");
            Element headerTd = domContext.createElement("td");
            headerTd.setAttribute("class", headerClass);
            handleId = ClientIdPool.get((String)(uiComponent.getClientId(facesContext) + "Handle"));
            headerTd.setAttribute("id", handleId);
            headerTr.appendChild(headerTd);
            Element headerTdSpacer = domContext.createElement("td");
            Element headerDiv = domContext.createElement("div");
            headerDiv.setAttribute("style", "width:1px;");
            headerTdSpacer.setAttribute("class", "icePnlPopHdr");
            headerTdSpacer.appendChild(headerDiv);
            headerTr.appendChild(headerTdSpacer);
            table.appendChild(headerTr);
            domContext.setCursorParent((Node)headerTd);
            UIComponent header = panelPopup.getHeader();
            CustomComponentUtils.renderChild(facesContext, header);
        }
        if (panelPopup.getBody() != null) {
            Element bodyTr = domContext.createElement("tr");
            Element bodyTd = domContext.createElement("td");
            bodyTd.setAttribute("class", bodyClass);
            bodyTr.setAttribute("id", ClientIdPool.get((String)(clientId + "-tr")));
            bodyTr.appendChild(bodyTd);
            bodyTd.setAttribute("colspan", "2");
            table.appendChild(bodyTr);
            domContext.setCursorParent((Node)bodyTd);
            UIComponent body = panelPopup.getBody();
            CustomComponentUtils.renderChild(facesContext, body);
        }
        if (resizable != null && resizable.booleanValue()) {
            Element footerTr = domContext.createElement("tr");
            footerTr.setAttribute("height", "15px");
            footerTr.setAttribute("style", "text-align: right; float: right;");
            Element footerTd = domContext.createElement("td");
            footerTd.setAttribute("styleClass", "panelPopupFooter");
            footerTd.setAttribute("colspan", "2");
            Element img = domContext.createElement("img");
            img.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/css/xp/css-images/resize.gif"));
            img.setAttribute("style", "cursor: se-resize");
            footerTd.appendChild(img);
            footerTr.appendChild(footerTd);
            table.appendChild(footerTr);
        }
        panelPopup.applyStyle(facesContext, root);
        domContext.stepOver();
        if (dndType != null) {
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.DnD.adjustPosition('" + uiComponent.getClientId(facesContext) + "');"));
            String call = this.addJavascriptCalls(uiComponent, "DRAG", handleId, facesContext);
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
            if (panelPopup.isClientOnly()) {
                Element clientOnly = domContext.createElement("input");
                clientOnly.setAttribute("type", "hidden");
                clientOnly.setAttribute("id", clientId + "clientOnly");
                root.appendChild(clientOnly);
            }
        }
        String autoPositionJS = null;
        boolean positionOnLoadOnly = panelPopup.isPositionOnLoadOnly();
        boolean dragged = panelPopup.isDragged();
        String positions = panelPopup.getAutoPosition();
        if (positions != null && !positions.equalsIgnoreCase("manual") && (!positionOnLoadOnly || positionOnLoadOnly && !dragged)) {
            if (positions.indexOf(44) < 1) {
                log.warn((Object)"The autoPosition attribute should be used with an  x and y value for the position, such as '20,40'");
            } else {
                String x = positions.substring(0, positions.indexOf(44));
                String y = positions.substring(positions.indexOf(44) + 1);
                autoPositionJS = "Ice.autoPosition.start('" + clientId + "'," + x + "," + y + ");";
            }
        } else {
            autoPositionJS = "Ice.autoPosition.stop('" + clientId + "');";
        }
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)autoPositionJS);
        boolean autoCentre = panelPopup.isAutoCentre();
        String centreJS = autoCentre && (!positionOnLoadOnly || positionOnLoadOnly && !dragged) ? "Ice.autoCentre.start('" + clientId + "');" : "Ice.autoCentre.stop('" + clientId + "');";
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)centreJS);
        if (panelPopup instanceof PanelTooltip) {
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("ToolTipPanelPopupUtil.adjustPosition('" + clientId + "');"));
        }
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.iFrameFix.start('" + clientId + "','" + CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/blank") + "');"));
    }

    protected void doPassThru(FacesContext facesContext, UIComponent uiComponent, Element root) {
        PassThruAttributeRenderer.renderNonBooleanHtmlAttributes((UIComponent)uiComponent, (Element)root, (String[])PASSTHRU);
        LocalEffectEncoder.encode((FacesContext)facesContext, (UIComponent)uiComponent, (String[])PASSTHRU_JS_EVENTS, null, (Element)root, null);
    }

    private String modalJavascript(UIComponent uiComponent, Boolean modal, Boolean visible, FacesContext facesContext, String clientId) {
        String call = null;
        String iframeUrl = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/blank");
        if (modal != null) {
            if (modal.booleanValue() && visible.booleanValue()) {
                String trigger = "";
                if (!((PanelPopup)uiComponent).isRunningModal()) {
                    Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
                    if (requestParameterMap.get("ice.focus") != null) {
                        trigger = (String)requestParameterMap.get("ice.focus");
                    }
                    ((PanelPopup)uiComponent).setRunningModal(true);
                    ((BridgeFacesContext)facesContext).setFocusId("");
                }
                String autoPosition = (String)uiComponent.getAttributes().get("autoPosition");
                call = "Ice.modal.start('" + clientId + "', '" + iframeUrl + "', '" + trigger + "'," + "manual".equalsIgnoreCase(autoPosition) + ");";
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Starting Modal Function");
                }
            } else {
                if (((PanelPopup)uiComponent).isRunningModal()) {
                    ((PanelPopup)uiComponent).setRunningModal(false);
                    ((BridgeFacesContext)facesContext).setFocusId("");
                }
                call = "Ice.modal.stop('" + clientId + "');";
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Stopping modal function");
                }
            }
        }
        return call;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Encode End Called");
        }
    }
}

