/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.Handler;

public class RequestManager {
    private static final Log LOG = LogFactory.getLog((Class)RequestManager.class);
    private final Map pendingRequestMap = new HashMap();

    public RequestManager() {
        if (LOG.isDebugEnabled()) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        StringBuffer _pendingRequests = new StringBuffer();
                        Map map = RequestManager.this.pendingRequestMap;
                        synchronized (map) {
                            Iterator _entries = RequestManager.this.pendingRequestMap.entrySet().iterator();
                            while (_entries.hasNext()) {
                                Map.Entry _entry = _entries.next();
                                _pendingRequests.append(_entry.getKey()).append(" - ").append(_entry.getValue()).append(" [").append(((Handler)_entry.getValue()).getRequest().getRemoteAddr()).append("]\r\n");
                            }
                        }
                        LOG.debug((Object)("Pending requests:\r\n\r\n" + _pendingRequests));
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler pull(Set iceFacesIdSet) {
        if (iceFacesIdSet == null || iceFacesIdSet.isEmpty()) {
            return null;
        }
        Map map = this.pendingRequestMap;
        synchronized (map) {
            Iterator _iceFacesIds = iceFacesIdSet.iterator();
            while (_iceFacesIds.hasNext()) {
                Handler _handler = this.pull((String)_iceFacesIds.next());
                if (_handler == null) continue;
                return _handler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler pull(String iceFacesId) {
        if (iceFacesId == null || iceFacesId.trim().length() == 0) {
            return null;
        }
        Map map = this.pendingRequestMap;
        synchronized (map) {
            Iterator _entries = this.pendingRequestMap.entrySet().iterator();
            while (_entries.hasNext()) {
                Map.Entry _entry = _entries.next();
                if (!((Set)_entry.getKey()).contains(iceFacesId)) continue;
                _entries.remove();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unparked pending request: ICEfaces ID set [" + _entry.getKey() + "]"));
                }
                return (Handler)_entry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Set iceFacesIdSet, Handler handler) {
        if (iceFacesIdSet == null || iceFacesIdSet.isEmpty() || handler == null) {
            return;
        }
        Map map = this.pendingRequestMap;
        synchronized (map) {
            this.pendingRequestMap.put(iceFacesIdSet, handler);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parked pending request: ICEfaces ID set [" + iceFacesIdSet + "]"));
            }
        }
    }
}

