/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.Color;
import java.awt.Paint;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.properties.AreaChartProperties;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

public class AreaTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return false;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        return new AreaChartProperties();
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(10.0, 50.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 3.0);
        DataSeries dataSeries = super.createDataSeries(n);
        ChartType chartType = null;
        chartType = TestDataGenerator.getRandomNumber(1.0) > 0.5 ? ChartType.AREA : ChartType.AREA_STACKED;
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(chartType, AreaTestDriver.getChartTypeProperties(n2), n2, n, 0, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        double[][] dArrayArray = new double[][]{{10.0, 15.0, 30.0}, {30.0, 30.0, 10.0}, {20.0, 25.0, 20.0}};
        Paint[] paintArray = new Paint[]{new Color(0, 255, 0, 100), new Color(255, 0, 0, 100), new Color(0, 0, 255, 100)};
        String[] stringArray2 = new String[]{"Legend Label", "Legend Label", "Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.AREA, areaChartProperties);
        String[] stringArray3 = new String[]{"1", "2", "3"};
        DataSeries dataSeries = new DataSeries(stringArray3, "X-Axis Title", "Y-Axis Title", "Chart Title");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        chartProperties.setEdgePadding(50.0f);
        AxisProperties axisProperties = new AxisProperties(false);
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setNumItems(4);
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "AreaChartTest.png");
    }
}

