/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.util.Properties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.PushServerMessageService;
import org.icefaces.push.server.SequenceNumbers;
import org.icefaces.push.server.SessionManager;
import org.icefaces.push.server.UpdatedViews;
import org.icefaces.push.server.UpdatedViewsQueue;
import org.icefaces.push.server.UpdatedViewsQueueExceededException;

public class UpdatedViewsManager {
    protected static final String UPDATED_VIEWS_QUEUE_EXCEEDED_MESSAGE_TYPE = "UpdatedViewsQueueExceeded";
    private static final Log LOG = LogFactory.getLog((Class)UpdatedViewsManager.class);
    protected final PushServerMessageService pushServerMessageService;
    protected final SessionManager sessionManager;
    protected final Map updatedViewsQueueMap = new HashMap();
    protected int updatedViewsQueueSize;

    public UpdatedViewsManager(Configuration configuration, PushServerMessageService pushServerMessageService, SessionManager sessionManager) {
        this.setUpdatedViewsQueueSize(configuration.getAttributeAsInteger("updatedViewsQueueSize", 100));
        this.pushServerMessageService = pushServerMessageService;
        this.sessionManager = sessionManager;
    }

    public int getUpdatedViewsQueueSize() {
        return this.updatedViewsQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List pull(Set iceFacesIdSet, SequenceNumbers sequenceNumbers) {
        if (iceFacesIdSet == null || iceFacesIdSet.isEmpty()) {
            return null;
        }
        Map map = this.updatedViewsQueueMap;
        synchronized (map) {
            ArrayList<UpdatedViews> _updatedViewsList = new ArrayList<UpdatedViews>();
            Iterator _iceFacesIds = iceFacesIdSet.iterator();
            int _size = iceFacesIdSet.size();
            for (int i = 0; i < _size; ++i) {
                String _iceFacesId = (String)_iceFacesIds.next();
                if (!this.updatedViewsQueueMap.containsKey(_iceFacesId)) continue;
                UpdatedViewsQueue _updatedViewsQueue = (UpdatedViewsQueue)this.updatedViewsQueueMap.get(_iceFacesId);
                Long _sequenceNumber = sequenceNumbers.get(_iceFacesId);
                if (_sequenceNumber != null) {
                    _updatedViewsQueue.purge(_sequenceNumber);
                }
                if (_updatedViewsQueue.isEmpty()) continue;
                Iterator _updatedViewsQueueIterator = _updatedViewsQueue.iterator();
                UpdatedViews _updatedViews = (UpdatedViews)_updatedViewsQueueIterator.next();
                while (_updatedViewsQueueIterator.hasNext()) {
                    _updatedViews = UpdatedViews.merge(_updatedViews, (UpdatedViews)_updatedViewsQueueIterator.next());
                }
                _updatedViewsList.add(_updatedViews);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pulled pending updated views: " + iceFacesIdSet));
            }
            return _updatedViewsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(UpdatedViews updatedViews) {
        if (updatedViews != null) {
            String _iceFacesId = updatedViews.getICEfacesID();
            Map map = this.updatedViewsQueueMap;
            synchronized (map) {
                UpdatedViewsQueue _updatedViewsQueue;
                if (this.updatedViewsQueueMap.containsKey(_iceFacesId)) {
                    _updatedViewsQueue = (UpdatedViewsQueue)this.updatedViewsQueueMap.get(_iceFacesId);
                } else {
                    _updatedViewsQueue = this.newUpdatedViewsQueue(_iceFacesId, this);
                    this.updatedViewsQueueMap.put(_iceFacesId, _updatedViewsQueue);
                }
                try {
                    _updatedViewsQueue.add(updatedViews);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Pushed pending updated views: " + _iceFacesId + " " + "[size: " + _updatedViewsQueue.getSize() + "]"));
                    }
                }
                catch (UpdatedViewsQueueExceededException exception) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Updated views queue exceeded: " + updatedViews.getICEfacesID()));
                    }
                    _updatedViewsQueue.clear();
                    Properties _messageProperties = new Properties();
                    _messageProperties.setStringProperty("destination_servletContextPath", this.sessionManager.getServletContextPath(updatedViews.getICEfacesID()));
                    this.pushServerMessageService.publish(updatedViews.getICEfacesID(), _messageProperties, UPDATED_VIEWS_QUEUE_EXCEEDED_MESSAGE_TYPE, "icefacesPush");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String iceFacesId) {
        if (iceFacesId != null && iceFacesId.trim().length() != 0) {
            Map map = this.updatedViewsQueueMap;
            synchronized (map) {
                if (this.updatedViewsQueueMap.containsKey(iceFacesId)) {
                    this.updatedViewsQueueMap.remove(iceFacesId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String iceFacesId, String viewNumber) {
        if (iceFacesId != null && iceFacesId.trim().length() != 0) {
            Map map = this.updatedViewsQueueMap;
            synchronized (map) {
                if (this.updatedViewsQueueMap.containsKey(iceFacesId)) {
                    UpdatedViewsQueue _updatedViewsQueue = (UpdatedViewsQueue)this.updatedViewsQueueMap.get(iceFacesId);
                    Iterator _iterator = _updatedViewsQueue.iterator();
                    while (_iterator.hasNext()) {
                        UpdatedViews _updatedViews = (UpdatedViews)_iterator.next();
                        if (!_updatedViews.contains(viewNumber)) continue;
                        _updatedViews.remove(viewNumber);
                        if (_updatedViews.size() != 0) continue;
                        _iterator.remove();
                    }
                }
            }
        }
    }

    public void setUpdatedViewsQueueSize(int updatedViewsQueueSize) throws IllegalArgumentException {
        if (updatedViewsQueueSize <= 0) {
            throw new IllegalArgumentException("illegal updated views queue size: " + updatedViewsQueueSize);
        }
        this.updatedViewsQueueSize = updatedViewsQueueSize;
    }

    protected UpdatedViewsQueue newUpdatedViewsQueue(String iceFacesId, UpdatedViewsManager updatedViewsManager) {
        return new UpdatedViewsQueue(iceFacesId, updatedViewsManager);
    }
}

