/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import org.krysalis.jcharts.Legend;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLGenerator;

public abstract class Chart
implements Serializable {
    private Graphics2D graphics2D;
    private int width;
    private int height;
    private Legend legend;
    private ChartProperties chartProperties;
    private boolean generateImageMap = false;
    private ImageMap imageMap = null;
    private BufferedImage bufferedImage = null;

    public Chart(LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.chartProperties = chartProperties;
        if (legendProperties != null) {
            this.legend = new Legend(this, legendProperties);
            legendProperties.setSize(new Dimension(this.width, this.height));
        }
    }

    public boolean getGenerateImageMapFlag() {
        return this.generateImageMap;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void renderWithImageMap() throws ChartDataException, PropertyException {
        this.bufferedImage = new BufferedImage(this.getImageWidth(), this.getImageHeight(), 1);
        this.setGraphics2D(this.bufferedImage.createGraphics());
        this.generateImageMap = true;
        this.render();
    }

    public void render() throws ChartDataException, PropertyException {
        if (this.chartProperties.useAntiAliasing()) {
            this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
        this.graphics2D.setPaint(this.chartProperties.getBackgroundPaint());
        this.graphics2D.fill(float_);
        if (this.chartProperties.getBorderStroke() != null) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            this.chartProperties.getBorderStroke().draw(this.graphics2D, float_);
        }
        this.renderChart();
    }

    protected float renderChartTitle(String string, FontRenderContext fontRenderContext) {
        float f = 0.0f;
        if (string != null) {
            float f2 = this.getChartProperties().getEdgePadding();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.getChartProperties().getTitleFont().getFont());
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            this.getGraphics2D().setPaint(this.getChartProperties().getTitleFont().getPaint());
            float f3 = (float)this.getImageWidth() - this.getChartProperties().getEdgePadding() * 2.0f;
            TextLayout textLayout = null;
            while ((textLayout = lineBreakMeasurer.nextLayout(f3)) != null) {
                textLayout.draw(this.getGraphics2D(), ((float)this.getImageWidth() - textLayout.getAdvance()) / 2.0f, f2 += textLayout.getAscent());
                f += textLayout.getAscent() + textLayout.getDescent();
            }
            f += this.getChartProperties().getTitlePadding();
        }
        return f;
    }

    protected abstract void renderChart() throws ChartDataException, PropertyException;

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    public final ChartProperties getChartProperties() {
        return this.chartProperties;
    }

    protected final Legend getLegend() {
        return this.legend;
    }

    public final boolean hasLegend() {
        return this.legend != null;
    }

    public final void setGraphics2D(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
    }

    public final Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    public final void setImageMap(ImageMap imageMap) {
        this.imageMap = imageMap;
    }

    public final ImageMap getImageMap() {
        return this.imageMap;
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string, ImageMap imageMap) {
        hTMLGenerator.chartTableStart(this.getClass().getName(), string, imageMap);
        hTMLGenerator.chartTableRowStart();
        this.chartProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        if (this.legend != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

