/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.webapp;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AuthenticationProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterEntryPoint == null ? (class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterEntryPoint = AuthenticationProcessingFilterEntryPoint.class$("org.acegisecurity.ui.webapp.AuthenticationProcessingFilterEntryPoint")) : class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterEntryPoint));
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private String loginFormUrl;
    private boolean forceHttps = false;
    static /* synthetic */ Class class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterEntryPoint;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.loginFormUrl, (String)"loginFormUrl must be specified");
        Assert.notNull((Object)this.portMapper, (String)"portMapper must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        Integer httpsPort;
        HttpServletRequest req = (HttpServletRequest)request;
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = this.portResolver.getServerPort(request);
        String contextPath = req.getContextPath();
        boolean inHttp = "http".equals(scheme.toLowerCase());
        boolean inHttps = "https".equals(scheme.toLowerCase());
        boolean includePort = true;
        if (inHttp && serverPort == 80) {
            includePort = false;
        } else if (inHttps && serverPort == 443) {
            includePort = false;
        }
        String redirectUrl = scheme + "://" + serverName + (includePort ? ":" + serverPort : "") + contextPath + this.loginFormUrl;
        if (this.forceHttps && inHttp && (httpsPort = this.portMapper.lookupHttpsPort(new Integer(serverPort))) != null) {
            includePort = httpsPort != 443;
            redirectUrl = "https://" + serverName + (includePort ? ":" + httpsPort : "") + contextPath + this.loginFormUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to: " + redirectUrl));
        }
        ((HttpServletResponse)response).sendRedirect(((HttpServletResponse)response).encodeRedirectURL(redirectUrl));
    }

    public boolean getForceHttps() {
        return this.forceHttps;
    }

    public String getLoginFormUrl() {
        return this.loginFormUrl;
    }

    public PortMapper getPortMapper() {
        return this.portMapper;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public void setLoginFormUrl(String loginFormUrl) {
        this.loginFormUrl = loginFormUrl;
    }

    public void setPortMapper(PortMapper portMapper) {
        this.portMapper = portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

