/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.el.PartialSubmitValueBinding;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class PartialSubmitPhaseListener
implements PhaseListener {
    private static final String REQUIRED = "required";
    private static final String ALTERED_KEY = "org.icefaces.altered-components";
    private static final String ICE_PARTIAL = "ice.submit.partial";
    private static final String ICE_CAPTURED = "ice.event.captured";
    private static final String TRUE = "true";

    public void afterPhase(PhaseEvent phaseEvent) {
        Map parameterMap;
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PhaseId.RESTORE_VIEW == phaseEvent.getPhaseId() && TRUE.equals((parameterMap = externalContext.getRequestParameterMap()).get(ICE_PARTIAL))) {
            String componentID = (String)parameterMap.get(ICE_CAPTURED);
            UIComponent component = D2DViewHandler.findComponent(componentID, (UIComponent)facesContext.getViewRoot());
            Map alteredRequiredComponents = this.setRequiredFalseInFormContaining(component, componentID);
            Map requestMap = externalContext.getRequestMap();
            requestMap.put(ALTERED_KEY, alteredRequiredComponents);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        Map requestMap;
        Map alteredComponents;
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PhaseId.RENDER_RESPONSE == phaseEvent.getPhaseId() && null != (alteredComponents = (Map)(requestMap = externalContext.getRequestMap()).get(ALTERED_KEY))) {
            this.setRequiredTrue((Map)requestMap.get(ALTERED_KEY));
            requestMap.remove(ALTERED_KEY);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void setRequiredTrue(Map requiredComponents) {
        Iterator i = requiredComponents.keySet().iterator();
        UIInput next = null;
        while (i.hasNext()) {
            next = (UIInput)i.next();
            ValueBinding valueBinding = (ValueBinding)requiredComponents.get(next);
            if (null != valueBinding) {
                next.setValueBinding(REQUIRED, valueBinding);
                continue;
            }
            next.setRequired(true);
        }
    }

    private Map setRequiredFalseInFormContaining(UIComponent component, String clientId) {
        HashMap alteredComponents = new HashMap();
        UIComponent form = this.getContainingForm(component);
        this.setRequiredFalseOnAllChildrenExceptOne(form, component, clientId, alteredComponents);
        return alteredComponents;
    }

    private void setRequiredFalseOnAllChildrenExceptOne(UIComponent parent, UIComponent componentToAvoid, String clientIdToAvoid, Map alteredComponents) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBinding FALSE_BINDING = facesContext.getApplication().createValueBinding("#{false}");
        Iterator kidsAndFacets = parent.getFacetsAndChildren();
        while (kidsAndFacets.hasNext()) {
            UIComponent next = (UIComponent)kidsAndFacets.next();
            if (next instanceof UIInput) {
                UIInput input = (UIInput)next;
                ValueBinding valueBinding = input.getValueBinding(REQUIRED);
                if (null != valueBinding) {
                    ValueBinding replacementBinding = null;
                    replacementBinding = input == componentToAvoid ? new PartialSubmitValueBinding(valueBinding, input, clientIdToAvoid) : FALSE_BINDING;
                    input.setValueBinding(REQUIRED, replacementBinding);
                    alteredComponents.put(input, valueBinding);
                } else if (input.isRequired() && input != componentToAvoid && input.isValid()) {
                    input.setRequired(false);
                    alteredComponents.put(input, null);
                }
            }
            this.setRequiredFalseOnAllChildrenExceptOne(next, componentToAvoid, clientIdToAvoid, alteredComponents);
        }
    }

    private UIComponent getContainingForm(UIComponent component) {
        UIComponent parent;
        if (null == component) {
            return FacesContext.getCurrentInstance().getViewRoot();
        }
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }
}

