/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.securechannel.ChannelEntryPoint;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RetryWithHttpsEntryPoint
implements InitializingBean,
ChannelEntryPoint {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$securechannel$RetryWithHttpsEntryPoint == null ? (class$org$acegisecurity$securechannel$RetryWithHttpsEntryPoint = RetryWithHttpsEntryPoint.class$("org.acegisecurity.securechannel.RetryWithHttpsEntryPoint")) : class$org$acegisecurity$securechannel$RetryWithHttpsEntryPoint));
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    static /* synthetic */ Class class$org$acegisecurity$securechannel$RetryWithHttpsEntryPoint;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.portMapper, (String)"portMapper is required");
        Assert.notNull((Object)this.portResolver, (String)"portResolver is required");
    }

    public void commence(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        String contextPath = req.getContextPath();
        String destination = req.getServletPath() + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
        String redirectUrl = contextPath;
        Integer httpPort = new Integer(this.portResolver.getServerPort((ServletRequest)req));
        Integer httpsPort = this.portMapper.lookupHttpsPort(httpPort);
        if (httpsPort != null) {
            boolean includePort = true;
            if (httpsPort == 443) {
                includePort = false;
            }
            redirectUrl = "https://" + req.getServerName() + (includePort ? ":" + httpsPort : "") + contextPath + destination;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to: " + redirectUrl));
        }
        ((HttpServletResponse)response).sendRedirect(((HttpServletResponse)response).encodeRedirectURL(redirectUrl));
    }

    public PortMapper getPortMapper() {
        return this.portMapper;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setPortMapper(PortMapper portMapper) {
        this.portMapper = portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

