/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.client;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.DefaultObjectSupplier;
import org.apache.axis2.engine.ObjectSupplier;

public class RPCServiceClient
extends ServiceClient {
    private boolean notNullService;

    public RPCServiceClient(ConfigurationContext configContext, AxisService service) throws AxisFault {
        super(configContext, service);
        if (service != null) {
            this.notNullService = true;
        }
    }

    public RPCServiceClient() throws AxisFault {
    }

    public RPCServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        super(configContext, wsdlURL, wsdlServiceName, portName);
        this.notNullService = true;
    }

    public OMElement invokeBlocking(QName opName, Object[] args) throws AxisFault {
        OMElement omElement = BeanUtil.getOMElement(opName, args, null, false, null);
        if (this.notNullService) {
            return super.sendReceive(opName, omElement);
        }
        return super.sendReceive(omElement);
    }

    public Object[] invokeBlocking(QName opName, Object[] args, Class[] returnTypes) throws AxisFault {
        OMElement omElement = BeanUtil.getOMElement(opName, args, null, false, null);
        OMElement response = this.notNullService ? super.sendReceive(opName, omElement) : super.sendReceive(omElement);
        return BeanUtil.deserialize(response, returnTypes, (ObjectSupplier)new DefaultObjectSupplier());
    }

    public void invokeNonBlocking(QName opName, Object[] args, Callback callback) throws AxisFault {
        OMElement omElement = BeanUtil.getOMElement(opName, args, null, false, null);
        if (this.notNullService) {
            super.sendReceiveNonBlocking(opName, omElement, callback);
        } else {
            super.sendReceiveNonBlocking(omElement, callback);
        }
    }

    public void invokeNonBlocking(QName opName, Object[] args, AxisCallback callback) throws AxisFault {
        OMElement omElement = BeanUtil.getOMElement(opName, args, null, false, null);
        if (this.notNullService) {
            super.sendReceiveNonBlocking(opName, omElement, callback);
        } else {
            super.sendReceiveNonBlocking(omElement, callback);
        }
    }

    public void invokeRobust(QName opName, Object[] args) throws AxisFault {
        OMElement omElement = BeanUtil.getOMElement(opName, args, null, false, null);
        if (this.notNullService) {
            super.sendRobust(opName, omElement);
        } else {
            super.sendRobust(omElement);
        }
    }
}

