/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.servlet.jsp.el.ELException;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_impl$util$ClassUtils == null ? (class$org$apache$myfaces$shared_impl$util$ClassUtils = ClassUtils.class$("org.apache.myfaces.shared_impl.util.ClassUtils")) : class$org$apache$myfaces$shared_impl$util$ClassUtils));
    private static final Logger COERCION_LOGGER = new Logger(System.out);
    public static final Class BOOLEAN_ARRAY_CLASS = array$Z == null ? (array$Z = ClassUtils.class$("[Z")) : array$Z;
    public static final Class BYTE_ARRAY_CLASS = array$B == null ? (array$B = ClassUtils.class$("[B")) : array$B;
    public static final Class CHAR_ARRAY_CLASS = array$C == null ? (array$C = ClassUtils.class$("[C")) : array$C;
    public static final Class SHORT_ARRAY_CLASS = array$S == null ? (array$S = ClassUtils.class$("[S")) : array$S;
    public static final Class INT_ARRAY_CLASS = array$I == null ? (array$I = ClassUtils.class$("[I")) : array$I;
    public static final Class LONG_ARRAY_CLASS = array$J == null ? (array$J = ClassUtils.class$("[J")) : array$J;
    public static final Class FLOAT_ARRAY_CLASS = array$F == null ? (array$F = ClassUtils.class$("[F")) : array$F;
    public static final Class DOUBLE_ARRAY_CLASS = array$D == null ? (array$D = ClassUtils.class$("[D")) : array$D;
    public static final Class OBJECT_ARRAY_CLASS = array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ClassUtils.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
    public static final Class BOOLEAN_OBJECT_ARRAY_CLASS = array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = ClassUtils.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean;
    public static final Class BYTE_OBJECT_ARRAY_CLASS = array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ClassUtils.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte;
    public static final Class CHARACTER_OBJECT_ARRAY_CLASS = array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ClassUtils.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character;
    public static final Class SHORT_OBJECT_ARRAY_CLASS = array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = ClassUtils.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short;
    public static final Class INTEGER_OBJECT_ARRAY_CLASS = array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = ClassUtils.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer;
    public static final Class LONG_OBJECT_ARRAY_CLASS = array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = ClassUtils.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long;
    public static final Class FLOAT_OBJECT_ARRAY_CLASS = array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = ClassUtils.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float;
    public static final Class DOUBLE_OBJECT_ARRAY_CLASS = array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = ClassUtils.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double;
    public static final Class STRING_OBJECT_ARRAY_CLASS = array$Ljava$lang$String == null ? (array$Ljava$lang$String = ClassUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
    public static final Map COMMON_TYPES = new HashMap(64);
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$util$ClassUtils;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class array$Ljava$lang$Double;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    private ClassUtils() {
    }

    public static Class classForName(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, (class$org$apache$myfaces$shared_impl$util$ClassUtils == null ? (class$org$apache$myfaces$shared_impl$util$ClassUtils = ClassUtils.class$("org.apache.myfaces.shared_impl.util.ClassUtils")) : class$org$apache$myfaces$shared_impl$util$ClassUtils).getClassLoader());
        }
    }

    public static Class simpleClassForName(String type) {
        try {
            return ClassUtils.classForName(type);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class " + type + " not found"), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Class javaTypeToClass(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Class clazz = (Class)COMMON_TYPES.get(type);
        if (clazz != null) {
            return clazz;
        }
        int len = type.length();
        if (len > 2 && type.charAt(len - 1) == ']' && type.charAt(len - 2) == '[') {
            String componentType = type.substring(0, len - 2);
            Class componentTypeClass = ClassUtils.classForName(componentType);
            return Array.newInstance(componentTypeClass, 0).getClass();
        }
        return ClassUtils.classForName(type);
    }

    public static Class simpleJavaTypeToClass(String type) {
        try {
            return ClassUtils.javaTypeToClass(type);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class " + type + " not found"), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = (class$org$apache$myfaces$shared_impl$util$ClassUtils == null ? (class$org$apache$myfaces$shared_impl$util$ClassUtils = ClassUtils.class$("org.apache.myfaces.shared_impl.util.ClassUtils")) : class$org$apache$myfaces$shared_impl$util$ClassUtils).getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    public static Iterator getResources(String resource, Object defaultObject) {
        try {
            Enumeration<URL> resources = ClassUtils.getCurrentLoader(defaultObject).getResources(resource);
            ArrayList<URL> lst = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                lst.add(resources.nextElement());
            }
            return lst.iterator();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Object newInstance(String type) throws FacesException {
        if (type == null) {
            return null;
        }
        return ClassUtils.newInstance(ClassUtils.simpleClassForName(type));
    }

    public static Object newInstance(Class clazz) throws FacesException {
        try {
            return clazz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)("Class : " + clazz.getName() + " not found."), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Object convertToType(Object value, Class desiredClass) {
        if (value == null) {
            return null;
        }
        try {
            return Coercions.coerce((Object)value, (Class)desiredClass, (Logger)COERCION_LOGGER);
        }
        catch (ELException e) {
            String message = "Cannot coerce " + value.getClass().getName() + " to " + desiredClass.getName();
            log.error((Object)message, (Throwable)e);
            throw new FacesException(message, (Throwable)e);
        }
    }

    protected static ClassLoader getCurrentLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        COMMON_TYPES.put("byte", Byte.TYPE);
        COMMON_TYPES.put("char", Character.TYPE);
        COMMON_TYPES.put("double", Double.TYPE);
        COMMON_TYPES.put("float", Float.TYPE);
        COMMON_TYPES.put("int", Integer.TYPE);
        COMMON_TYPES.put("long", Long.TYPE);
        COMMON_TYPES.put("short", Short.TYPE);
        COMMON_TYPES.put("boolean", Boolean.TYPE);
        COMMON_TYPES.put("void", Void.TYPE);
        COMMON_TYPES.put("java.lang.Object", class$java$lang$Object == null ? (class$java$lang$Object = ClassUtils.class$("java.lang.Object")) : class$java$lang$Object);
        COMMON_TYPES.put("java.lang.Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        COMMON_TYPES.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        COMMON_TYPES.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character);
        COMMON_TYPES.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short);
        COMMON_TYPES.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        COMMON_TYPES.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long);
        COMMON_TYPES.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float);
        COMMON_TYPES.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double);
        COMMON_TYPES.put("java.lang.String", class$java$lang$String == null ? (class$java$lang$String = ClassUtils.class$("java.lang.String")) : class$java$lang$String);
        COMMON_TYPES.put("byte[]", BYTE_ARRAY_CLASS);
        COMMON_TYPES.put("char[]", CHAR_ARRAY_CLASS);
        COMMON_TYPES.put("double[]", DOUBLE_ARRAY_CLASS);
        COMMON_TYPES.put("float[]", FLOAT_ARRAY_CLASS);
        COMMON_TYPES.put("int[]", INT_ARRAY_CLASS);
        COMMON_TYPES.put("long[]", LONG_ARRAY_CLASS);
        COMMON_TYPES.put("short[]", SHORT_ARRAY_CLASS);
        COMMON_TYPES.put("boolean[]", BOOLEAN_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Object[]", OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Boolean[]", BOOLEAN_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Byte[]", BYTE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Character[]", CHARACTER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Short[]", SHORT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Integer[]", INTEGER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Long[]", LONG_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Float[]", FLOAT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Double[]", DOUBLE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.String[]", STRING_OBJECT_ARRAY_CLASS);
    }
}

