/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnonymousBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_KEY = "key";
    static final String DEF_KEY = "doesNotMatter";
    static final String ATT_USERNAME = "username";
    static final String DEF_USERNAME = "roleAnonymous";
    static final String ATT_GRANTED_AUTHORITY = "granted-authority";
    static final String DEF_GRANTED_AUTHORITY = "ROLE_ANONYMOUS";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$security$providers$anonymous$AnonymousProcessingFilter;
    static /* synthetic */ Class class$org$springframework$security$providers$anonymous$AnonymousAuthenticationProvider;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String grantedAuthority = null;
        String username = null;
        String key = null;
        Object source = null;
        if (element != null) {
            grantedAuthority = element.getAttribute(ATT_GRANTED_AUTHORITY);
            username = element.getAttribute(ATT_USERNAME);
            key = element.getAttribute(ATT_KEY);
            source = parserContext.extractSource((Object)element);
        }
        if (!StringUtils.hasText(grantedAuthority)) {
            grantedAuthority = DEF_GRANTED_AUTHORITY;
        }
        if (!StringUtils.hasText(username)) {
            username = DEF_USERNAME;
        }
        if (!StringUtils.hasText(key)) {
            key = DEF_KEY;
        }
        RootBeanDefinition filter = new RootBeanDefinition(class$org$springframework$security$providers$anonymous$AnonymousProcessingFilter == null ? (class$org$springframework$security$providers$anonymous$AnonymousProcessingFilter = AnonymousBeanDefinitionParser.class$("org.springframework.security.providers.anonymous.AnonymousProcessingFilter")) : class$org$springframework$security$providers$anonymous$AnonymousProcessingFilter);
        filter.setSource(source);
        filter.getPropertyValues().addPropertyValue("userAttribute", (Object)(username + "," + grantedAuthority));
        filter.getPropertyValues().addPropertyValue(ATT_KEY, (Object)key);
        BeanDefinition authManager = ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        RootBeanDefinition provider = new RootBeanDefinition(class$org$springframework$security$providers$anonymous$AnonymousAuthenticationProvider == null ? (class$org$springframework$security$providers$anonymous$AnonymousAuthenticationProvider = AnonymousBeanDefinitionParser.class$("org.springframework.security.providers.anonymous.AnonymousAuthenticationProvider")) : class$org$springframework$security$providers$anonymous$AnonymousAuthenticationProvider);
        provider.setRole(2);
        provider.setSource(source);
        provider.getPropertyValues().addPropertyValue(ATT_KEY, (Object)key);
        ManagedList authMgrProviderList = (ManagedList)authManager.getPropertyValues().getPropertyValue("providers").getValue();
        authMgrProviderList.add(provider);
        parserContext.getRegistry().registerBeanDefinition("_anonymousProcessingFilter", (BeanDefinition)filter);
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)new RuntimeBeanReference("_anonymousProcessingFilter"));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)filter, "_anonymousProcessingFilter"));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

