/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public abstract class GenericPortlet
implements Portlet,
PortletConfig {
    private transient PortletConfig config;

    public void init(PortletConfig portletConfig) throws PortletException {
        this.config = portletConfig;
        this.init();
    }

    public void init() throws PortletException {
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        throw new PortletException("processAction method not implemented");
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        renderResponse.setTitle(this.getTitle(renderRequest));
        this.doDispatch(renderRequest, renderResponse);
    }

    protected String getTitle(RenderRequest renderRequest) {
        return this.config.getResourceBundle(renderRequest.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        WindowState windowState = renderRequest.getWindowState();
        if (!windowState.equals(WindowState.MINIMIZED)) {
            PortletMode portletMode = renderRequest.getPortletMode();
            if (portletMode.equals(PortletMode.VIEW)) {
                this.doView(renderRequest, renderResponse);
            } else if (portletMode.equals(PortletMode.EDIT)) {
                this.doEdit(renderRequest, renderResponse);
            } else if (portletMode.equals(PortletMode.HELP)) {
                this.doHelp(renderRequest, renderResponse);
            } else {
                throw new PortletException("unknown portlet mode: " + portletMode);
            }
        }
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public void destroy() {
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.config.getResourceBundle(locale);
    }

    public String getInitParameter(String string) {
        return this.config.getInitParameter(string);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }
}

