/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewHandlerImpl
extends ViewHandler {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$application$ViewHandlerImpl == null ? (class$com$sun$faces$application$ViewHandlerImpl = ViewHandlerImpl.class$("com.sun.faces.application.ViewHandlerImpl")) : class$com$sun$faces$application$ViewHandlerImpl));
    private static final String INVOCATION_PATH = "com.sun.faces.INVOCATION_PATH";
    private String contextDefaultSuffix;
    static /* synthetic */ Class class$com$sun$faces$application$ViewHandlerImpl;

    public ViewHandlerImpl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created ViewHandler instance ");
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (null == context || null == viewToRender) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context + " viewToRender " + viewToRender;
            throw new NullPointerException(message);
        }
        ApplicationAssociate associate = ApplicationAssociate.getInstance(context.getExternalContext());
        if (null != associate) {
            associate.responseRendered();
        }
        String requestURI = viewToRender.getViewId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to render view " + requestURI));
        }
        String mapping = this.getFacesMapping(context);
        String newViewId = requestURI;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found URL pattern mapping to FacesServlet " + mapping));
            }
            newViewId = this.convertViewId(context, requestURI);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Found no URL patterns mapping to FacesServlet ");
        }
        viewToRender.setViewId(newViewId);
        if (context.getExternalContext().getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)context.getExternalContext().getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Before dispacthMessage to newViewId " + newViewId));
        }
        context.getExternalContext().dispatch(newViewId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("After dispacthMessage to newViewId " + newViewId));
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        Map headerMap = extContext.getRequestHeaderMap();
        String contentType = null;
        String charEnc = null;
        contentType = (String)headerMap.get("Content-Type");
        if (null != contentType) {
            String charsetStr = "charset=";
            int len = charsetStr.length();
            int i = 0;
            i = contentType.indexOf(charsetStr);
            if (-1 != i && i + len < contentType.length()) {
                charEnc = contentType.substring(i + len);
            }
        }
        if (null == charEnc && null != extContext.getSession(false)) {
            charEnc = (String)extContext.getSessionMap().get("javax.faces.request.charset");
        }
        if (null != charEnc) {
            try {
                Object request;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("set character encoding on request to " + charEnc));
                }
                if ((request = extContext.getRequest()) instanceof ServletRequest) {
                    ((ServletRequest)request).setCharacterEncoding(charEnc);
                }
            }
            catch (UnsupportedEncodingException uee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)uee.getMessage(), (Throwable)uee);
                }
                throw new FacesException((Throwable)uee);
            }
        }
        String mapping = this.getFacesMapping(context);
        UIViewRoot viewRoot = null;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            viewId = this.convertViewId(context, viewId);
        }
        if (extContext.getRequestPathInfo() == null && mapping != null && ViewHandlerImpl.isPrefixMapped(mapping)) {
            try {
                context.responseComplete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response Complete for" + viewId));
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = context.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(context);
            viewRoot = Util.getStateManager(context).restoreView(context, viewId, renderKitId);
        }
        return viewRoot;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot result = new UIViewRoot();
        result.setViewId(viewId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new view for " + viewId));
        }
        if (locale == null) {
            locale = context.getApplication().getViewHandler().calculateLocale(context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Locale for this view as determined by calculateLocale " + locale.toString()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Using locale from previous view " + locale.toString()));
        }
        if (renderKitId == null) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Using renderKitId from previous view " + renderKitId));
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    public Locale calculateLocale(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale perf = (Locale)locales.next();
            result = this.findMatch(context, perf);
            if (result != null) break;
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        String result = null;
        result = context.getApplication().getDefaultRenderKitId();
        if (null == result) {
            result = "HTML_BASIC";
        }
        return result;
    }

    protected Locale findMatch(FacesContext context, Locale perf) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (perf.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!perf.getLanguage().equals(supportedLocale.getLanguage()) || !supportedLocale.getCountry().equals("")) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (perf.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (perf.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().equals("")) {
                result = defaultLocale;
            }
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin writing state to response for viewId" + context.getViewRoot().getViewId()));
        }
        context.getResponseWriter().writeText((Object)"com.sun.faces.saveStateFieldMarker", null);
        if (log.isTraceEnabled()) {
            log.trace((Object)("End writing state to response for viewId" + context.getViewRoot().getViewId()));
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (context == null || viewId == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context + " viewId " + viewId;
            throw new NullPointerException(message);
        }
        if (viewId.charAt(0) != '/') {
            String message = Util.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", new Object[]{viewId});
            if (log.isErrorEnabled()) {
                log.error((Object)(message + " " + viewId));
            }
            throw new IllegalArgumentException(message);
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        String mapping = this.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(".");
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    private String getFacesMapping(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            if ((mapping = this.getMappingForRequest(servletPath, pathInfo)) == null) {
                String message = Util.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_CANNOT_BE_DETERMINED", new Object[]{servletPath});
                if (log.isWarnEnabled()) {
                    log.warn((Object)message);
                }
            }
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("URL pattern of the FacesServlet executing the current request " + mapping));
        }
        return mapping;
    }

    private String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("servletPath " + servletPath));
            log.trace((Object)("pathInfo " + pathInfo));
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (pathInfo == null && servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    private static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertViewId(FacesContext context, String viewId) {
        ViewHandlerImpl viewHandlerImpl = this;
        synchronized (viewHandlerImpl) {
            if (this.contextDefaultSuffix == null) {
                this.contextDefaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                if (this.contextDefaultSuffix == null) {
                    this.contextDefaultSuffix = ".jsp";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("contextDefaultSuffix " + this.contextDefaultSuffix));
                }
            }
        }
        String convertedViewId = viewId;
        if (!convertedViewId.endsWith(this.contextDefaultSuffix)) {
            StringBuffer buffer = new StringBuffer(convertedViewId);
            int extIdx = convertedViewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, convertedViewId.length(), this.contextDefaultSuffix);
            } else {
                buffer.append(this.contextDefaultSuffix);
            }
            convertedViewId = buffer.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("viewId after appending the context suffix " + convertedViewId));
            }
        }
        return convertedViewId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

