/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.ext.HtmlCommandButton;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.outputchart.AbstractChart;
import com.icesoft.faces.component.outputchart.ChartResource;
import com.icesoft.faces.context.DOMContext;
import java.beans.Beans;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.imageMap.ImageMapArea;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OutputChart
extends HtmlCommandButton
implements Serializable {
    public static final String SCATTER_PLOT_CHART_TYPE = "scatterplot";
    public static String AREA_CHART_TYPE = "area";
    public static String AREA_STACKED_CHART_TYPE = "areastacked";
    public static String BAR_CHART_TYPE = "bar";
    public static String BAR_CLUSTERED_CHART_TYPE = "barclustered";
    public static String BAR_STACKED_CHART_TYPE = "barstacked";
    public static String LINE_CHART_TYPE = "line";
    public static String PIE2D_CHART_TYPE = "pie2D";
    public static String PIE3D_CHART_TYPE = "pie3D";
    public static String POINT_CHART_TYPE = "point";
    public static String STOCK_CHART_TYPE = "stock";
    public static String CUSTOM_CHART_TYPE = "custom";
    public static String DEFAULT_CHART_TYPE = BAR_CHART_TYPE;
    private static int COMPONENT_ID = 0;
    private static int CLIENT_SIDE_IMAGE_MAP_KEY = 1;
    private static String DEFAULT_HEIGHT = "400";
    private static String DEFAULT_WIDTH = "400";
    private static String DEFAULT_CHART_TITLE = "Default Chart title";
    private static String DEFAULT_YAXIS_TITLE = "Default Y title";
    private static String DEFAULT_XAXIS_TITLE = "Default X title";
    private static String DEFAULT_DATA = "20, 30, 40";
    static String ICE_CHART_COMPONENT = "iceChartComponent";
    private transient int imageCounter = 0;
    private String width;
    private String height;
    private boolean render = false;
    private String chartTitle;
    private Object data;
    private Object labels;
    private Object colors;
    private Object shapes;
    private Object xaxisLabels;
    private String xaxisTitle;
    private String yaxisTitle;
    private String style = null;
    private String styleClass = null;
    private Object legendPlacement;
    private Object legendColumns;
    private boolean horizontal;
    private boolean horizontalSet;
    private URI chartURI;
    private ChartResource chartResource;
    private MethodBinding renderOnSubmitMethodBinding;
    private String type = null;
    private String parentFormId;

    public OutputChart() {
        this.setRendererType("com.icesoft.faces.OutputChartRenderer");
    }

    public Object getLabels() {
        if (this.labels != null) {
            return this.labels;
        }
        ValueBinding vb = this.getValueBinding("labels");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setLabels(Object labels) {
        this.labels = labels;
    }

    public boolean isClientSideImageMap() {
        return this.hasActionListener() && !this.getType().equalsIgnoreCase(AREA_CHART_TYPE) && !this.getType().equalsIgnoreCase(AREA_STACKED_CHART_TYPE);
    }

    protected boolean hasActionListener() {
        MethodBinding actionListener = this.getActionListener();
        if (actionListener != null) {
            return true;
        }
        ActionListener[] actionListeners = this.getActionListeners();
        return actionListeners != null && actionListeners.length > 0;
    }

    public Object getData() {
        if (this.data != null) {
            return this.data;
        }
        ValueBinding vb = this.getValueBinding("data");
        if (vb != null) {
            return vb.getValue(this.getFacesContext());
        }
        if (!Beans.isDesignTime()) {
            this.setChartTitle(this.getChartTitle() + " with default data");
        }
        return DEFAULT_DATA;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getColors() {
        if (this.colors != null) {
            return this.colors;
        }
        ValueBinding vb = this.getValueBinding("colors");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setColors(Object colors) {
        this.colors = colors;
    }

    public Object getShapes() {
        if (this.shapes != null) {
            return this.shapes;
        }
        ValueBinding vb = this.getValueBinding("shapes");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setShapes(Object shapes) {
        this.shapes = shapes;
    }

    public String getXaxisTitle() {
        if (this.xaxisTitle != null) {
            return this.xaxisTitle;
        }
        ValueBinding vb = this.getValueBinding("xaxisTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_XAXIS_TITLE;
    }

    public void setXaxisTitle(String xaxisTitle) {
        this.xaxisTitle = xaxisTitle;
    }

    public String getYaxisTitle() {
        if (this.yaxisTitle != null) {
            return this.yaxisTitle;
        }
        ValueBinding vb = this.getValueBinding("yaxisTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_YAXIS_TITLE;
    }

    public void setYaxisTitle(String yaxisTitle) {
        this.yaxisTitle = yaxisTitle;
    }

    public Object getXaxisLabels() {
        if (this.xaxisLabels != null) {
            return this.xaxisLabels;
        }
        ValueBinding vb = this.getValueBinding("xaxisLabels");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setXaxisLabels(Object xaxisLabels) {
        this.xaxisLabels = xaxisLabels;
    }

    public String getChartTitle() {
        if (this.chartTitle != null) {
            return this.chartTitle;
        }
        ValueBinding vb = this.getValueBinding("chartTitle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_CHART_TITLE;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_WIDTH;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_HEIGHT;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setRenderOnSubmit(MethodBinding renderOnSubmit) {
        this.renderOnSubmitMethodBinding = renderOnSubmit;
    }

    public MethodBinding getRenderOnSubmit() {
        return this.renderOnSubmitMethodBinding;
    }

    public Boolean evaluateRenderOnSubmit(FacesContext context) {
        if (this.renderOnSubmitMethodBinding != null) {
            Boolean b = (Boolean)this.renderOnSubmitMethodBinding.invoke(context, new Object[]{this});
            return b;
        }
        return Boolean.FALSE;
    }

    public void decode(FacesContext context) {
        ImageMapArea area;
        String[] submittedValue;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String chartComponentRequestIdentifier = (String)requestParameterMap.get(ICE_CHART_COMPONENT);
        if (chartComponentRequestIdentifier != null && (submittedValue = chartComponentRequestIdentifier.split("id-key"))[COMPONENT_ID].equals(this.getClientId(context)) && (area = (ImageMapArea)this.getGeneratedImageMapArea().get(submittedValue[CLIENT_SIDE_IMAGE_MAP_KEY])) != null) {
            this.setClickedImageMapArea(area);
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
        super.decode(context);
    }

    public Chart getChart() {
        return this.getAbstractChart().getChart();
    }

    public void setChart(Chart chart) {
        this.getAbstractChart().setChart(chart);
    }

    public void render() {
        this.render = true;
    }

    public boolean isRender() {
        return this.render;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_CHART_TYPE;
    }

    Map getGeneratedImageMapArea() {
        return this.getAbstractChart().getGeneratedImageMapArea();
    }

    public ImageMapArea getClickedImageMapArea() {
        return this.getAbstractChart().getClickedImageMapArea();
    }

    public void setClickedImageMapArea(ImageMapArea clickedImageMapArea) {
        this.getAbstractChart().setClickedImageMapArea(clickedImageMapArea);
    }

    void generateClientSideImageMap(DOMContext domContext, Element map) {
        if (this.isClientSideImageMap()) {
            Iterator area = this.getGeneratedImageMapArea().values().iterator();
            while (area.hasNext()) {
                ImageMapArea areaMap = (ImageMapArea)area.next();
                Text areaNode = domContext.createTextNode(areaMap.toHTML("title ='" + areaMap.getLengendLabel() + "' href=\"javascript:;\" onclick=\"document.forms['" + this.getParentFormId() + "']['" + ICE_CHART_COMPONENT + "'].value='" + this.getClientId(this.getFacesContext()) + "id-key" + areaMap.hashCode() + "';iceSubmitPartial(document.forms['" + this.getParentFormId() + "'],this,event); return false;\""));
                map.appendChild(areaNode);
            }
        }
    }

    private String getParentFormId() {
        if (this.parentFormId != null) {
            return this.parentFormId;
        }
        UIComponent uiForm = FormRenderer.findForm((UIComponent)this);
        if (uiForm == null) {
            return null;
        }
        this.parentFormId = uiForm.getClientId(this.getFacesContext());
        return this.parentFormId;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceOutChrt", "styleClass");
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object getLegendPlacement() {
        if (this.legendPlacement != null) {
            return this.legendPlacement;
        }
        ValueBinding vb = this.getValueBinding("legendPlacement");
        return vb != null ? vb.getValue(this.getFacesContext()) : "bottom";
    }

    public void setLegendPlacement(Object legendPlacement) {
        this.legendPlacement = legendPlacement;
    }

    public Object getLegendColumns() {
        if (this.legendColumns != null) {
            return this.legendColumns;
        }
        ValueBinding vb = this.getValueBinding("legendColumns");
        return vb != null ? vb.getValue(this.getFacesContext()) : "0";
    }

    public void setLegendColumns(Object legendColumns) {
        this.legendColumns = legendColumns;
    }

    public boolean isHorizontal() {
        if (this.horizontalSet) {
            return this.horizontal;
        }
        ValueBinding vb = this.getValueBinding("horizontal");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        if (horizontal != this.horizontal) {
            this.horizontal = horizontal;
        }
        this.horizontalSet = true;
    }

    AbstractChart createAbstractChart() throws Throwable {
        return this.getAttributes().put(this.getClientId(this.getFacesContext()), AbstractChart.createChart((UIComponent)this));
    }

    AbstractChart getAbstractChart() {
        Object abstractChart = this.getAttributes().get(this.getClientId(this.getFacesContext()));
        return abstractChart != null ? (AbstractChart)abstractChart : null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[24];
        values[0] = super.saveState(context);
        values[2] = this.width;
        values[3] = this.height;
        values[4] = this.render ? Boolean.TRUE : Boolean.FALSE;
        values[5] = this.chartTitle;
        values[6] = this.data;
        values[7] = this.labels;
        values[8] = this.colors;
        values[9] = this.shapes;
        values[10] = this.xaxisLabels;
        values[11] = this.xaxisTitle;
        values[12] = this.yaxisTitle;
        values[13] = this.style;
        values[14] = this.styleClass;
        values[15] = this.legendPlacement;
        values[16] = this.legendColumns;
        values[17] = this.horizontal ? Boolean.TRUE : Boolean.FALSE;
        values[18] = this.horizontalSet ? Boolean.TRUE : Boolean.FALSE;
        values[19] = this.chartURI;
        values[20] = this.chartResource;
        values[21] = OutputChart.saveAttachedState((FacesContext)context, (Object)this.renderOnSubmitMethodBinding);
        values[22] = this.type;
        values[23] = this.parentFormId;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.width = (String)values[2];
        this.height = (String)values[3];
        this.render = (Boolean)values[4];
        this.chartTitle = (String)values[5];
        this.data = values[6];
        this.labels = values[7];
        this.colors = values[8];
        this.shapes = values[9];
        this.xaxisLabels = values[10];
        this.xaxisTitle = (String)values[11];
        this.yaxisTitle = (String)values[12];
        this.style = (String)values[13];
        this.styleClass = (String)values[14];
        this.legendPlacement = values[15];
        this.legendColumns = values[16];
        this.horizontal = (Boolean)values[17];
        this.horizontalSet = (Boolean)values[18];
        this.chartURI = (URI)values[19];
        this.chartResource = (ChartResource)values[20];
        this.renderOnSubmitMethodBinding = (MethodBinding)OutputChart.restoreAttachedState((FacesContext)context, (Object)values[21]);
        this.type = (String)values[22];
        this.parentFormId = (String)values[23];
    }

    public ChartResource getChartResource() {
        return this.chartResource;
    }

    public void setChartResource(ChartResource chartResource) {
        this.chartResource = chartResource;
    }

    public URI getChartURI() {
        return this.chartURI;
    }

    public void setChartURI(URI chartURI) {
        this.chartURI = chartURI;
    }
}

