/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.memory.UserMap;
import org.springframework.security.userdetails.memory.UserMapEditor;
import org.springframework.util.Assert;

public class InMemoryDaoImpl
implements UserDetailsService,
InitializingBean {
    private UserMap userMap;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userMap, (String)"A list of users, passwords, enabled/disabled status and their granted authorities must be set");
    }

    public UserMap getUserMap() {
        return this.userMap;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.userMap.getUser(username);
    }

    public void setUserMap(UserMap userMap) {
        this.userMap = userMap;
    }

    public void setUserProperties(Properties props) {
        UserMap userMap = new UserMap();
        this.userMap = UserMapEditor.addUsersFromProperties(userMap, props);
    }
}

