/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.adapters;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class HttpRequestIntegrationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$adapters$HttpRequestIntegrationFilter == null ? (class$org$springframework$security$adapters$HttpRequestIntegrationFilter = HttpRequestIntegrationFilter.class$("org.springframework.security.adapters.HttpRequestIntegrationFilter")) : class$org$springframework$security$adapters$HttpRequestIntegrationFilter));
    static /* synthetic */ Class class$org$springframework$security$adapters$HttpRequestIntegrationFilter;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            Principal principal = ((HttpServletRequest)request).getUserPrincipal();
            if (principal != null && principal instanceof Authentication) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)principal);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SecurityContextHolder updated with Authentication from container: '" + principal + "'"));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContextHolder not set with new Authentication as Principal was: '" + principal + "'"));
            }
        } else {
            throw new IllegalArgumentException("Only HttpServletRequest is acceptable");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

