/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapEncoder;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.util.Assert;

public class SpringSecurityLdapTemplate
extends LdapTemplate {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ldap$SpringSecurityLdapTemplate == null ? (class$org$springframework$security$ldap$SpringSecurityLdapTemplate = SpringSecurityLdapTemplate.class$("org.springframework.security.ldap.SpringSecurityLdapTemplate")) : class$org$springframework$security$ldap$SpringSecurityLdapTemplate));
    public static final String[] NO_ATTRS = new String[0];
    private SearchControls searchControls = new SearchControls();
    static /* synthetic */ Class class$org$springframework$security$ldap$SpringSecurityLdapTemplate;

    public SpringSecurityLdapTemplate(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"ContextSource cannot be null");
        this.setContextSource(contextSource);
        this.searchControls.setSearchScope(2);
    }

    public boolean compare(String dn, String attributeName, Object value) {
        String comparisonFilter = "(" + attributeName + "={0})";
        class LdapCompareCallback
        implements ContextExecutor {
            private final /* synthetic */ String val$dn;
            private final /* synthetic */ String val$comparisonFilter;
            private final /* synthetic */ Object val$value;

            LdapCompareCallback(String string, String string2, Object object) {
                this.val$dn = string;
                this.val$comparisonFilter = string2;
                this.val$value = object;
            }

            public Object executeWithContext(DirContext ctx) throws NamingException {
                SearchControls ctls = new SearchControls();
                ctls.setReturningAttributes(NO_ATTRS);
                ctls.setSearchScope(0);
                NamingEnumeration<SearchResult> results = ctx.search(this.val$dn, this.val$comparisonFilter, new Object[]{this.val$value}, ctls);
                return results.hasMore();
            }
        }
        Boolean matches = (Boolean)this.executeReadOnly(new LdapCompareCallback(dn, comparisonFilter, value));
        return matches;
    }

    public DirContextOperations retrieveEntry(final String dn, final String[] attributesToRetrieve) {
        return (DirContextOperations)this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attrs = ctx.getAttributes(dn, attributesToRetrieve);
                return new DirContextAdapter(attrs, (Name)new DistinguishedName(dn), (Name)new DistinguishedName(ctx.getNameInNamespace()));
            }
        });
    }

    public Set searchForSingleAttributeValues(String base, String filter, Object[] params, final String attributeName) {
        Object[] encodedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            encodedParams[i] = LdapEncoder.filterEncode((String)params[i].toString());
        }
        String formattedFilter = MessageFormat.format(filter, encodedParams);
        logger.debug((Object)("Using filter: " + formattedFilter));
        final HashSet set = new HashSet();
        ContextMapper roleMapper = new ContextMapper(){

            public Object mapFromContext(Object ctx) {
                DirContextAdapter adapter = (DirContextAdapter)ctx;
                String[] values = adapter.getStringAttributes(attributeName);
                if (values == null || values.length == 0) {
                    logger.debug((Object)("No attribute value found for '" + attributeName + "'"));
                } else {
                    set.addAll(Arrays.asList(values));
                }
                return null;
            }
        };
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.searchControls.getSearchScope());
        ctls.setReturningAttributes(new String[]{attributeName});
        ctls.setReturningObjFlag(false);
        this.search(base, formattedFilter, ctls, roleMapper);
        return set;
    }

    public DirContextOperations searchForSingleEntry(final String base, final String filter, final Object[] params) {
        return (DirContextOperations)this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                NamingEnumeration<SearchResult> results = ctx.search(base, filter, params, SpringSecurityLdapTemplate.this.searchControls);
                if (!results.hasMore()) {
                    throw new IncorrectResultSizeDataAccessException(1, 0);
                }
                SearchResult searchResult = results.next();
                if (results.hasMore()) {
                    throw new IncorrectResultSizeDataAccessException(1, 2);
                }
                StringBuffer dn = new StringBuffer(searchResult.getName());
                if (base.length() > 0) {
                    dn.append(",");
                    dn.append(base);
                }
                return new DirContextAdapter(searchResult.getAttributes(), (Name)new DistinguishedName(dn.toString()), (Name)new DistinguishedName(ctx.getNameInNamespace()));
            }
        });
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

