/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.axis2.jaxws.util.BaseWSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleWSDLLocator
extends BaseWSDLLocator
implements WSDLLocator {
    private static Log log = LogFactory.getLog(ModuleWSDLLocator.class);
    private ClassLoader classLoader;

    public ModuleWSDLLocator(String uri, InputStream stream, ClassLoader classLoader) {
        this.baseURI = this.convertURI(uri);
        this.baseInputStream = stream;
        this.classLoader = classLoader;
    }

    protected String getRedirectedURI(String importURI, String parent) {
        return null;
    }

    protected InputStream getInputStream(String importPath) throws IOException {
        URL importURL = null;
        InputStream is = null;
        try {
            importURL = new URL(importPath);
            is = importURL.openStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                is = this.classLoader.getResourceAsStream(importPath);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(importPath);
                is = file.toURL().openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                URI uri = new URI(importPath);
                is = uri.toURL().openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return is;
    }

    public URL getWsdlUrl(String wsdlLocation) {
        URL streamURL = null;
        InputStream is = null;
        URI pathURI = null;
        try {
            streamURL = new URL(wsdlLocation);
            is = streamURL.openStream();
            is.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                pathURI = new URI(wsdlLocation);
                streamURL = pathURI.toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(wsdlLocation);
                streamURL = file.toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled() && streamURL == null) {
            log.debug((Object)("Absolute wsdlLocation could not be determined: " + wsdlLocation));
        }
        return streamURL;
    }

    public void close() {
    }
}

