/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas;

import java.io.Serializable;
import java.util.List;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;

public class CasAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private final List proxyList;
    private final Object credentials;
    private final Object principal;
    private final String proxyGrantingTicketIou;
    private final UserDetails userDetails;
    private final int keyHash;

    public CasAuthenticationToken(String key, Object principal, Object credentials, GrantedAuthority[] authorities, UserDetails userDetails, List proxyList, String proxyGrantingTicketIou) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || proxyList == null || proxyGrantingTicketIou == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.proxyList = proxyList;
        this.proxyGrantingTicketIou = proxyGrantingTicketIou;
        this.setAuthenticated(true);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CasAuthenticationToken) {
            CasAuthenticationToken test = (CasAuthenticationToken)obj;
            if (!this.getProxyGrantingTicketIou().equals(test.getProxyGrantingTicketIou())) {
                return false;
            }
            if (!((Object)this.getProxyList()).equals(test.getProxyList())) {
                return false;
            }
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getProxyGrantingTicketIou() {
        return this.proxyGrantingTicketIou;
    }

    public List getProxyList() {
        return this.proxyList;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("; Credentials (Service/Proxy Ticket): ").append(this.credentials);
        sb.append("; Proxy-Granting Ticket IOU: ").append(this.proxyGrantingTicketIou);
        sb.append("; Proxy List: ").append(this.proxyList);
        return sb.toString();
    }
}

