/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.encoding;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.acegisecurity.providers.encoding.BaseDigestPasswordEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class MessageDigestPasswordEncoder
extends BaseDigestPasswordEncoder {
    private final String algorithm;

    public MessageDigestPasswordEncoder(String algorithm) {
        this(algorithm, false);
    }

    public MessageDigestPasswordEncoder(String algorithm, boolean encodeHashAsBase64) throws IllegalArgumentException {
        this.algorithm = algorithm;
        this.setEncodeHashAsBase64(encodeHashAsBase64);
        this.getMessageDigest();
    }

    public String encodePassword(String rawPass, Object salt) {
        String saltedPass = this.mergePasswordAndSalt(rawPass, salt, false);
        MessageDigest messageDigest = this.getMessageDigest();
        byte[] digest = messageDigest.digest(saltedPass.getBytes());
        if (this.getEncodeHashAsBase64()) {
            return new String(Base64.encodeBase64((byte[])digest));
        }
        return new String(Hex.encodeHex((byte[])digest));
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm [" + this.algorithm + "]");
        }
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = "" + encPass;
        String pass2 = this.encodePassword(rawPass, salt);
        return pass1.equals(pass2);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

