/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessagePipeline;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageSeparator;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceConfiguration;
import com.icesoft.net.messaging.MessageServiceConfigurationProperties;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.ObjectMessage;
import com.icesoft.net.messaging.PublishTask;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.util.ServerUtility;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageServiceClient {
    public static final String PUSH_TOPIC_NAME = "icefacesPush";
    private static final Log LOG = LogFactory.getLog((Class)MessageServiceClient.class);
    private final Map messageHandlerMap = new HashMap();
    private final Map messagePipelineMap = new HashMap();
    private Administrator administrator;
    private MessageServiceConfiguration messageServiceConfiguration;
    private MessageServiceAdapter messageServiceAdapter;
    private Properties baseMessageProperties = new Properties();
    private String name;
    private Timer timer = new Timer();

    public MessageServiceClient(MessageServiceConfiguration messageServiceConfiguration, MessageServiceAdapter messageServiceAdapter, ServletContext servletContext) throws IllegalArgumentException {
        this(null, messageServiceConfiguration, messageServiceAdapter, servletContext);
    }

    public MessageServiceClient(MessageServiceConfiguration messageServiceConfiguration, MessageServiceAdapter messageServiceAdapter, String servletContextPath) throws IllegalArgumentException {
        this(null, messageServiceConfiguration, messageServiceAdapter, servletContextPath);
    }

    public MessageServiceClient(MessageServiceAdapter messageServiceAdapter, ServletContext servletContext) throws IllegalArgumentException {
        this(null, null, messageServiceAdapter, servletContext);
    }

    public MessageServiceClient(MessageServiceAdapter messageServiceAdapter, String servletContextPath) throws IllegalArgumentException {
        this(null, null, messageServiceAdapter, servletContextPath);
    }

    public MessageServiceClient(String name, MessageServiceConfiguration messageServiceConfiguration, MessageServiceAdapter messageServiceAdapter, ServletContext servletContext) throws IllegalArgumentException {
        this(name, messageServiceConfiguration, messageServiceAdapter);
        this.setBaseMessageProperties(servletContext);
    }

    public MessageServiceClient(String name, MessageServiceConfiguration messageServiceConfiguration, MessageServiceAdapter messageServiceAdapter, String servletContextPath) throws IllegalArgumentException {
        this(name, messageServiceConfiguration, messageServiceAdapter);
        this.setBaseMessageProperties(servletContextPath);
    }

    public MessageServiceClient(String name, MessageServiceAdapter messageServiceAdapter, ServletContext servletContext) throws IllegalArgumentException {
        this(name, null, messageServiceAdapter, servletContext);
    }

    public MessageServiceClient(String name, MessageServiceAdapter messageServiceAdapter, String servletContextPath) throws IllegalArgumentException {
        this(name, null, messageServiceAdapter, servletContextPath);
    }

    private MessageServiceClient(String name, MessageServiceConfiguration messageServiceConfiguration, MessageServiceAdapter messageServiceAdapter) throws IllegalArgumentException {
        if (messageServiceAdapter == null) {
            throw new IllegalArgumentException("messageServiceAdapter is null");
        }
        this.name = name;
        if (messageServiceConfiguration != null) {
            this.messageServiceConfiguration = messageServiceConfiguration;
        } else {
            this.messageServiceConfiguration = new MessageServiceConfigurationProperties();
            this.messageServiceConfiguration.setMessageMaxDelay(100L);
            this.messageServiceConfiguration.setMessageMaxLength(10240);
        }
        this.messageServiceAdapter = messageServiceAdapter;
        this.messageServiceAdapter.setMessageServiceClient(this);
    }

    public void addMessageHandler(MessageHandler messageHandler, String topicName) {
        if (messageHandler != null && topicName != null && topicName.trim().length() != 0) {
            Map<MessageHandler, MessageSeparator> _messageHandlerWrapperMap;
            if (this.messageHandlerMap.containsKey(topicName)) {
                _messageHandlerWrapperMap = (Map)this.messageHandlerMap.get(topicName);
                if (_messageHandlerWrapperMap.containsKey(messageHandler)) {
                    return;
                }
            } else {
                _messageHandlerWrapperMap = new HashMap();
                this.messageHandlerMap.put(topicName, _messageHandlerWrapperMap);
            }
            MessageSeparator _messageSeparator = !(messageHandler instanceof MessageSeparator) ? new MessageSeparator(messageHandler) : (MessageSeparator)messageHandler;
            _messageHandlerWrapperMap.put(messageHandler, _messageSeparator);
            this.messageServiceAdapter.addMessageHandler(_messageSeparator, topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessageServiceException {
        try {
            this.messageServiceAdapter.close();
        }
        finally {
            this.messageHandlerMap.clear();
        }
    }

    public MessageServiceAdapter getMessageServiceAdapter() {
        return this.messageServiceAdapter;
    }

    public MessageServiceConfiguration getMessageServiceConfiguration() {
        return this.messageServiceConfiguration;
    }

    public Administrator getAdministrator() {
        return this.administrator;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPublisherTopicNames() {
        return this.messageServiceAdapter.getPublisherTopicNames();
    }

    public String[] getSubscriberTopicNames() {
        return this.messageServiceAdapter.getSubscriberTopicNames();
    }

    public boolean isPublishingOn(String topicName) {
        return topicName != null && topicName.trim().length() != 0 && this.messageServiceAdapter.isPublishingOn(topicName);
    }

    public boolean isSubscribedTo(String topicName) {
        return topicName != null && topicName.trim().length() != 0 && this.messageServiceAdapter.isSubscribedTo(topicName);
    }

    public void publish(Serializable object, Properties messageProperties, String topicName) {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publish(MessageServiceClient.createMessage(object, this.baseMessageProperties, messageProperties), topicName);
        }
    }

    public void publish(Serializable object, Properties messageProperties, String messageType, String topicName) {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publish(object, MessageServiceClient.getMessageProperties(messageProperties, messageType), topicName);
        }
    }

    public void publish(Serializable object, String topicName) {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publish(object, (Properties)null, topicName);
        }
    }

    public void publish(Serializable object, String messageType, String topicName) {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publish(object, MessageServiceClient.getMessageProperties(null, messageType), topicName);
        }
    }

    public void publish(String text, Properties messageProperties, String topicName) {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publish(MessageServiceClient.createMessage(text, this.baseMessageProperties, messageProperties), topicName);
        }
    }

    public void publish(String text, Properties messageProperties, String messageType, String topicName) {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publish(text, MessageServiceClient.getMessageProperties(messageProperties, messageType), topicName);
        }
    }

    public void publish(String text, String topicName) {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publish(text, (Properties)null, topicName);
        }
    }

    public void publish(String text, String messageType, String topicName) {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publish(text, MessageServiceClient.getMessageProperties(null, messageType), topicName);
        }
    }

    public void publishNow(Serializable object, Properties messageProperties, String topicName) throws MessageServiceException {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(MessageServiceClient.createMessage(object, this.baseMessageProperties, messageProperties), topicName);
        }
    }

    public void publishNow(Serializable object, Properties messageProperties, String messageType, String topicName) throws MessageServiceException {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(object, MessageServiceClient.getMessageProperties(messageProperties, messageType), topicName);
        }
    }

    public void publishNow(Serializable object, String topicName) throws MessageServiceException {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(object, (Properties)null, topicName);
        }
    }

    public void publishNow(Serializable object, String messageType, String topicName) throws MessageServiceException {
        if (object != null && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(object, MessageServiceClient.getMessageProperties(null, messageType), topicName);
        }
    }

    public void publishNow(String text, Properties messageProperties, String topicName) throws MessageServiceException {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(MessageServiceClient.createMessage(text, this.baseMessageProperties, messageProperties), topicName);
        }
    }

    public void publishNow(String text, Properties messageProperties, String messageType, String topicName) throws MessageServiceException {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(text, MessageServiceClient.getMessageProperties(messageProperties, messageType), topicName);
        }
    }

    public void publishNow(String text, String topicName) throws MessageServiceException {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(text, (Properties)null, topicName);
        }
    }

    public void publishNow(String text, String messageType, String topicName) throws MessageServiceException {
        if (text != null && text.trim().length() != 0 && topicName != null && topicName.trim().length() != 0) {
            this.publishNow(text, MessageServiceClient.getMessageProperties(null, messageType), topicName);
        }
    }

    public void removeMessageHandler(MessageHandler messageHandler, String topicName) {
        Map _messageHandlerWrapperMap;
        if (messageHandler != null && topicName != null && topicName.trim().length() != 0 && this.messageHandlerMap.containsKey(topicName) && (_messageHandlerWrapperMap = (Map)this.messageHandlerMap.get(topicName)).containsKey(messageHandler)) {
            this.messageServiceAdapter.removeMessageHandler((MessageSeparator)_messageHandlerWrapperMap.remove(messageHandler), topicName);
            if (_messageHandlerWrapperMap.isEmpty()) {
                this.messageHandlerMap.remove(topicName);
            }
        }
    }

    public void setAdministrator(Administrator administrator) {
        this.administrator = administrator;
    }

    public void start() throws MessageServiceException {
        this.messageServiceAdapter.start();
    }

    public void stop() throws MessageServiceException {
        this.messageServiceAdapter.stop();
    }

    public void subscribe(String topicName) throws MessageServiceException {
        this.subscribe(topicName, null, true);
    }

    public void subscribe(String topicName, boolean noLocal) throws MessageServiceException {
        this.subscribe(topicName, null, noLocal);
    }

    public void subscribe(String topicName, MessageSelector messageSelector) throws MessageServiceException {
        this.subscribe(topicName, messageSelector, true);
    }

    public void subscribe(String topicName, MessageSelector messageSelector, boolean noLocal) throws MessageServiceException {
        if (topicName != null && topicName.trim().length() != 0) {
            this.messageServiceAdapter.subscribe(topicName, messageSelector, noLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topicName) throws MessageServiceException {
        if (topicName != null && topicName.trim().length() != 0) {
            try {
                this.messageServiceAdapter.unsubscribe(topicName);
            }
            finally {
                this.messageHandlerMap.remove(topicName);
            }
        }
    }

    void schedule(PublishTask publishTask, long delay) {
        block2: {
            try {
                this.timer.schedule((TimerTask)publishTask, delay);
            }
            catch (IllegalStateException exception) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Task already scheduled or cancelled, timer was cancelled, or timer thread terminated.", (Throwable)exception);
            }
        }
    }

    private static void addMessageProperties(Properties messageProperties, Message message) {
        if (messageProperties == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> _messageProperties = messageProperties.entrySet().iterator();
        while (_messageProperties.hasNext()) {
            Map.Entry<Object, Object> _messageProperty = _messageProperties.next();
            Object _value = _messageProperty.getValue();
            if (_value instanceof Boolean) {
                message.setBooleanProperty((String)_messageProperty.getKey(), (Boolean)_value);
                continue;
            }
            if (_value instanceof Byte) {
                message.setByteProperty((String)_messageProperty.getKey(), (Byte)_value);
                continue;
            }
            if (_value instanceof Double) {
                message.setDoubleProperty((String)_messageProperty.getKey(), (Double)_value);
                continue;
            }
            if (_value instanceof Float) {
                message.setFloatProperty((String)_messageProperty.getKey(), ((Float)_value).floatValue());
                continue;
            }
            if (_value instanceof Integer) {
                message.setIntProperty((String)_messageProperty.getKey(), (Integer)_value);
                continue;
            }
            if (_value instanceof Long) {
                message.setLongProperty((String)_messageProperty.getKey(), (Long)_value);
                continue;
            }
            if (_value instanceof Short) {
                message.setShortProperty((String)_messageProperty.getKey(), (Short)_value);
                continue;
            }
            if (_value instanceof String) {
                message.setStringProperty((String)_messageProperty.getKey(), (String)_value);
                continue;
            }
            message.setObjectProperty((String)_messageProperty.getKey(), _value);
        }
    }

    private static Message createMessage(Serializable object, Properties baseMessageProperties, Properties messageProperties) {
        ObjectMessage _message = new ObjectMessage(object);
        MessageServiceClient.addMessageProperties(baseMessageProperties, _message);
        MessageServiceClient.addMessageProperties(messageProperties, _message);
        return _message;
    }

    private static Message createMessage(String text, Properties baseMessageProperties, Properties messageProperties) {
        TextMessage _message = new TextMessage(text);
        MessageServiceClient.addMessageProperties(baseMessageProperties, _message);
        MessageServiceClient.addMessageProperties(messageProperties, _message);
        return _message;
    }

    private static Properties getMessageProperties(Properties messageProperties, String messageType) {
        Properties _messageProperties = messageProperties != null ? messageProperties : new Properties();
        _messageProperties.setProperty("message_type", messageType);
        return _messageProperties;
    }

    private void publish(Message message, String topicName) {
        MessagePipeline _messagePipeline;
        String _messagePipelineId = topicName + "/" + message.getStringProperty("message_type");
        if (this.messagePipelineMap.containsKey(_messagePipelineId)) {
            _messagePipeline = (MessagePipeline)this.messagePipelineMap.get(_messagePipelineId);
        } else {
            _messagePipeline = new MessagePipeline(this, topicName);
            this.messagePipelineMap.put(_messagePipelineId, _messagePipeline);
        }
        _messagePipeline.enqueue(message);
    }

    private void publishNow(Message message, String topicName) throws MessageServiceException {
        this.messageServiceAdapter.publish(message, topicName);
    }

    private void setBaseMessageProperties() {
        block2: {
            try {
                this.baseMessageProperties.setProperty("source_nodeAddress", InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException exception) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"Failed to get IP address for localhost.", (Throwable)exception);
            }
        }
    }

    private void setBaseMessageProperties(ServletContext servletContext) {
        String _servletContextPath;
        if (servletContext != null && (_servletContextPath = ServerUtility.getServletContextPath(servletContext)) != null) {
            this.baseMessageProperties.setProperty("source_servletContextPath", _servletContextPath);
        }
        this.setBaseMessageProperties();
    }

    private void setBaseMessageProperties(String servletContextPath) {
        if (servletContextPath != null) {
            this.baseMessageProperties.setProperty("source_servletContextPath", servletContextPath);
        }
        this.setBaseMessageProperties();
    }

    public static interface Administrator {
        public void reconnect();

        public boolean reconnectNow();
    }
}

