/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.util.ArrayList;
import org.jibx.runtime.IListItemDeserializer;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class QName {
    private String m_uri;
    private String m_prefix;
    private String m_name;

    public QName(String uri, String prefix, String name) {
        this.m_uri = uri;
        this.m_prefix = prefix;
        this.m_name = name;
    }

    public QName(String uri, String name) {
        this(uri, null, name);
    }

    public QName(String name) {
        this(null, null, name);
    }

    public boolean equals(Object obj) {
        QName qname;
        if (obj instanceof QName && this.m_name.equals((qname = (QName)obj).getName())) {
            if (this.m_uri == null) {
                return qname.getUri() == null;
            }
            return this.m_uri.equals(qname.getUri());
        }
        return false;
    }

    public int hashCode() {
        return (this.m_uri == null ? 0 : this.m_uri.hashCode()) + this.m_name.hashCode();
    }

    public String toString() {
        if (this.m_uri == null) {
            return this.m_name;
        }
        return "{" + this.m_uri + "}:" + this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String uri) {
        this.m_uri = uri;
    }

    public static QName deserialize(String text, IUnmarshallingContext ictx) throws JiBXException {
        if (text == null) {
            return null;
        }
        int split = text.indexOf(58);
        if (split > 0) {
            String prefix = text.substring(0, split);
            text = text.substring(split + 1);
            String uri = ((UnmarshallingContext)ictx).getNamespaceUri(prefix);
            if (uri == null) {
                throw new JiBXException("Undefined prefix " + prefix);
            }
            return new QName(uri, prefix, text);
        }
        String uri = ((UnmarshallingContext)ictx).getNamespaceUri(null);
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        return new QName(uri, "", text);
    }

    public static String serialize(QName qname, IMarshallingContext ictx) throws JiBXException {
        int tryidx;
        if (qname == null) {
            return null;
        }
        IXMLWriter ixw = ((MarshallingContext)ictx).getXmlWriter();
        int index = -1;
        String uri = qname.getUri();
        if (uri == null) {
            uri = "";
        }
        if (qname.getPrefix() != null && (tryidx = ixw.getPrefixIndex(qname.getPrefix())) >= 0 && uri.equals(ixw.getNamespaceUri(tryidx))) {
            index = tryidx;
        }
        if (index < 0) {
            String[][] nsss;
            if (uri == null) {
                uri = "";
            }
            String[] nss = ixw.getNamespaces();
            for (int i = 0; i < nss.length; ++i) {
                if (!nss[i].equals(uri)) continue;
                index = i;
                break;
            }
            if (index < 0 && (nsss = ixw.getExtensionNamespaces()) != null) {
                int base = nss.length;
                block1: for (int i = 0; i < nsss.length; ++i) {
                    nss = nsss[i];
                    for (int j = 0; j < nss.length; ++j) {
                        if (!nss[j].equals(uri)) continue;
                        index = base + j;
                        break block1;
                    }
                    base += nss.length;
                }
            }
        }
        if (index >= 0) {
            String prefix = ixw.getNamespacePrefix(index);
            if (prefix == null) {
                throw new JiBXException("Namespace URI " + qname.getUri() + " cannot be used since it is not active");
            }
            if (prefix.length() > 0) {
                return prefix + ':' + qname.getName();
            }
            return qname.getName();
        }
        throw new JiBXException("Unknown namespace URI " + qname.m_uri);
    }

    public static QName[] deserializeList(String text, final IUnmarshallingContext ictx) throws JiBXException {
        IListItemDeserializer ldser = new IListItemDeserializer(){

            public Object deserialize(String text) throws JiBXException {
                return QName.deserialize(text, ictx);
            }
        };
        ArrayList list = Utility.deserializeList(text, ldser);
        if (list == null) {
            return null;
        }
        return list.toArray(new QName[list.size()]);
    }

    public static String serializeList(QName[] qnames, IMarshallingContext ictx) throws JiBXException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < qnames.length; ++i) {
            QName qname = qnames[i];
            if (qname == null) continue;
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(QName.serialize(qname, ictx));
        }
        return buff.toString();
    }
}

