/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.LeftParenthesisPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class MethodCallPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new MethodCallPrinter();

    protected MethodCallPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public static JavaNode getLastMethodCall(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 80: {
                return MethodCallPrinter.getLastMethodCall(parent.getParent());
            }
        }
        return node;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST identifier;
        boolean continuation = out.continuation;
        boolean lastInChain = false;
        ParenthesesScope scope = null;
        AST first = node.getFirstChild();
        if (out.mode == 1) {
            boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true);
            boolean forceWrappingForChainedCalls = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false);
            if ((wrapLines || forceWrappingForChainedCalls) && JavaNodeHelper.isChained(first)) {
                AST firstLink = JavaNodeHelper.getFirstChainLink(node);
                scope = (ParenthesesScope)out.state.parenScope.getFirst();
                if (scope.chainCall == null) {
                    scope.chainCall = firstLink;
                    AST child = firstLink.getFirstChild();
                    switch (child.getType()) {
                        case 80: {
                            TestNodeWriter tester = out.testers.get();
                            identifier = child.getFirstChild();
                            PrinterFactory.create(identifier, out).print(identifier, tester);
                            scope.chainOffset = out.column - 1 + tester.length;
                            out.testers.release(tester);
                            break;
                        }
                        default: {
                            scope.chainOffset = out.column - 1 + out.indentSize;
                        }
                    }
                    if (out.newline) {
                        scope.chainOffset += out.getIndentLength();
                    }
                    lastInChain = true;
                }
            }
        }
        boolean innerClass = false;
        Marker marker = null;
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            default: {
                marker = out.state.markers.add();
                break;
            }
            case 28: {
                AST next = parent.getFirstChild();
                AST type = null;
                switch (next.getType()) {
                    case 108: {
                        type = PrinterHelper.advanceToFirstNonParen(next);
                        break;
                    }
                    default: {
                        type = next;
                    }
                }
                identifier = type.getFirstChild();
                int length = 0;
                switch (identifier.getType()) {
                    case 80: {
                        ++length;
                        AST temp = identifier.getFirstChild();
                        block19: while (temp != null && temp != identifier) {
                            if (temp.getType() == 80) {
                                temp = temp.getFirstChild();
                                ++length;
                                continue;
                            }
                            length += temp.getText().length();
                            if (temp.getNextSibling() == null) {
                                while (temp != identifier) {
                                    if ((temp = ((JavaNode)temp).getParent()).getNextSibling() == null) continue;
                                    temp = temp.getNextSibling();
                                    continue block19;
                                }
                                continue;
                            }
                            temp = temp.getNextSibling();
                        }
                    }
                    case 79: {
                        length = identifier.getText().length();
                        break;
                    }
                    case 22: {
                        length = identifier.getFirstChild().getText().length();
                        if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) break;
                        ++length;
                        break;
                    }
                    case 90: {
                        length = 7;
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 96: {
                        length = 4;
                        break;
                    }
                    case 93: 
                    case 95: {
                        length = 5;
                        break;
                    }
                    case 94: {
                        length = 3;
                        break;
                    }
                    case 97: {
                        length = 6;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected TYPE, was " + type);
                    }
                }
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_CAST, false)) {
                    length += 2;
                }
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_CAST, true)) {
                    ++length;
                }
                marker = out.state.markers.add(out.line, out.column - 3 - length);
            }
        }
        this.logIssues(node, out);
        PrinterFactory.create(first, out).print(first, out);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_METHOD_CALL_PAREN, false)) {
            out.print(" ", 175);
        }
        LeftParenthesisPrinter.getInstance().print(node, out);
        AST elist = first.getNextSibling();
        PrinterFactory.create(elist, out).print(elist, out);
        if (out.last == 19) {
            innerClass = true;
        }
        AST rparen = elist.getNextSibling();
        PrinterFactory.create(rparen, out).print(rparen, out);
        if (innerClass) {
            out.last = 19;
        }
        out.state.markers.remove(marker);
        if (lastInChain && scope != null) {
            scope.chainCall = null;
        }
        if (out.continuation && !continuation) {
            out.continuation = false;
        }
    }

    static AST getChainParent(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 33: 
            case 157: {
                return MethodCallPrinter.getChainParent(parent);
            }
        }
        return parent;
    }

    static boolean isOuterMethodCall(AST node) {
        JavaNode call = MethodCallPrinter.getLastMethodCall((JavaNode)node);
        if (call.getPreviousSibling().getType() == 108) {
            return false;
        }
        JavaNode expr = call.getParent();
        return MethodCallPrinter.getChainParent(expr).getType() != 39;
    }
}

