/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData.processors;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import org.krysalis.jcharts.chartText.TextTag;

public class TextProcessor {
    private float widestLabel = Float.MIN_VALUE;
    private float tallestLabel = Float.MIN_VALUE;
    private float totalLabelWidths = 0.0f;
    private ArrayList textTags = new ArrayList(30);

    public void addLabel(String string, Font font, FontRenderContext fontRenderContext) {
        TextTag textTag = new TextTag(string, font, fontRenderContext);
        this.textTags.add(textTag);
        this.widestLabel = Math.max(textTag.getWidth(), this.widestLabel);
        this.totalLabelWidths += textTag.getWidth();
        this.tallestLabel = Math.max(textTag.getHeight(), this.tallestLabel);
    }

    public int size() {
        return this.textTags.size();
    }

    public float getWidestLabel() {
        return this.widestLabel;
    }

    public float getTallestLabel() {
        return this.tallestLabel;
    }

    public float getTotalLabelWidths() {
        return this.totalLabelWidths;
    }

    public TextTag getTextTag(int n) {
        return (TextTag)this.textTags.get(n);
    }
}

