/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.BarChart;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.imageMap.RectMapArea;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.StackedBarChartProperties;

abstract class StackedBarChart {
    StackedBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) throws ChartDataException {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        StackedBarChartProperties stackedBarChartProperties = (StackedBarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties();
            float f = axisChart.getYAxis().getScalePixelWidth() * stackedBarChartProperties.getPercentage();
            float f2 = axisChart.getXAxis().getZeroLineCoordinate();
            float f3 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f4 = 0.0f;
            float f5 = f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
            StackedBarChart.horizontalPlot(axisChart, iAxisChartDataSet, stackedBarChartProperties, dataAxisProperties, graphics2D, float_, f2);
        } else {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
            float f = axisChart.getXAxis().getScalePixelWidth() * stackedBarChartProperties.getPercentage();
            float f6 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f7 = axisChart.getYAxis().getZeroLineCoordinate();
            float f8 = f;
            float f9 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f7, f8, f9);
            StackedBarChart.verticalPlot(axisChart, iAxisChartDataSet, stackedBarChartProperties, dataAxisProperties, graphics2D, float_, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, StackedBarChartProperties stackedBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) throws ChartDataException {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < iAxisChartDataSet.getNumberOfDataSets(); ++j) {
                if (iAxisChartDataSet.getValue(j, i) == 0.0) continue;
                if (iAxisChartDataSet.getValue(j, i) < 0.0) {
                    throw new ChartDataException("Negative values in Stacked Bar charts are not supported yet... Coming soon...");
                }
                float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(j, i), axisChart.getXAxis().getOneUnitPixelSize());
                graphics2D.setPaint(iAxisChartDataSet.getPaint(j));
                graphics2D.fill(float_);
                if (stackedBarChartProperties.getShowOutlinesFlag()) {
                    stackedBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                }
                if (axisChart.getGenerateImageMapFlag()) {
                    String string = null;
                    if (axisChart.getYAxis().getAxisLabelsGroup() != null) {
                        string = axisChart.getYAxis().getAxisLabelsGroup().getTextTag(n).getText();
                    }
                    axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(j, i), string, iAxisChartDataSet.getLegendLabel(j)));
                }
                float_.x += float_.width;
            }
            --n;
            float_.y += axisChart.getYAxis().getScalePixelWidth();
            float_.x = f;
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, StackedBarChartProperties stackedBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < iAxisChartDataSet.getNumberOfDataSets(); ++j) {
                if (iAxisChartDataSet.getValue(j, i) == 0.0) continue;
                float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(j, i), axisChart.getYAxis().getOneUnitPixelSize());
                float_.y -= float_.height;
                graphics2D.setPaint(iAxisChartDataSet.getPaint(j));
                graphics2D.fill(float_);
                if (stackedBarChartProperties.getShowOutlinesFlag()) {
                    stackedBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                }
                if (!axisChart.getGenerateImageMapFlag()) continue;
                String string = null;
                if (axisChart.getXAxis().getAxisLabelsGroup() != null) {
                    string = axisChart.getXAxis().getAxisLabelsGroup().getTextTag(i).getText();
                }
                axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(j, i), string, iAxisChartDataSet.getLegendLabel(j)));
            }
            float_.x += axisChart.getXAxis().getScalePixelWidth();
            float_.y = f;
        }
    }
}

