/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.krysalis.jcharts.axisChart.customRenderers.axisValue.renderers.ValueLabelRenderer;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ClusteredBarChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.properties.util.ChartStroke;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

public class ClusteredBarTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(1.0, 10.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 4.0);
        DataSeries dataSeries = super.createDataSeries(n);
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.BAR_CLUSTERED, clusteredBarChartProperties, n2, n, -5000, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, false, false, 0);
        valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.ON_TOP);
        valueLabelRenderer.useVerticalLabels(false);
        clusteredBarChartProperties.addPostRenderEventListener(valueLabelRenderer);
        double[][] dArrayArray = new double[][]{{280.0, 0.0, -150.0, 90.0}, {80.0, 216.0, -10.0, 30.0}};
        Paint[] paintArray = new Paint[]{Color.yellow, Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label", "other data"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.BAR_CLUSTERED, clusteredBarChartProperties);
        String[] stringArray3 = new String[]{"1900", "1950", "2000", "2050"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Cookies", "Years", null);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        axisProperties.getYAxisProperties().setShowGridLines(0);
        axisProperties.getYAxisProperties().setAxisStroke(new ChartStroke(new BasicStroke(1.5f), Color.red));
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = null;
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "ClusteredBarChartTest.png");
    }
}

