/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.encoders;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.encoders.JPEGEncoder;
import org.krysalis.jcharts.encoders.JPEGEncoder13;
import org.krysalis.jcharts.encoders.PNGEncoder;
import org.krysalis.jcharts.encoders.SVGEncoder;
import org.krysalis.jcharts.properties.PropertyException;

public class ServletEncoderHelper {
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String JPEG_MIME_TYPE = "image/jpeg";

    public static void encodeServlet(Chart chart, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(SVG_MIME_TYPE);
        SVGEncoder.encode(chart, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static void encodeJPEG13(Chart chart, float f, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(JPEG_MIME_TYPE);
        JPEGEncoder13.encode(chart, f, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static void encodeJPEG(Chart chart, float f, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(JPEG_MIME_TYPE);
        JPEGEncoder.encode(chart, f, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static void encodePNG(Chart chart, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(PNG_MIME_TYPE);
        PNGEncoder.encode(chart, (OutputStream)httpServletResponse.getOutputStream());
    }
}

