/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.krysalis.jcharts.axisChart.ScatterPlotAxisChart;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.chartData.ScatterPlotDataSeries;
import org.krysalis.jcharts.chartData.ScatterPlotDataSet;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.properties.ScatterPlotProperties;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;

public class ScatterPlotTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    private ScatterPlotProperties getScatterPlotProperties(int n) {
        Stroke[] strokeArray = new Stroke[n];
        for (int i = 0; i < n; ++i) {
            strokeArray[i] = LineChartProperties.DEFAULT_LINE_STROKE;
        }
        strokeArray[0] = new BasicStroke(3.0f);
        Shape[] shapeArray = new Shape[n];
        for (int i = 0; i < n; ++i) {
            shapeArray[i] = PointChartProperties.SHAPE_DIAMOND;
        }
        shapeArray[0] = PointChartProperties.SHAPE_CIRCLE;
        return new ScatterPlotProperties(strokeArray, shapeArray);
    }

    private ScatterPlotDataSet createScatterPlotDataSet(int n, int n2, int n3, int n4, int n5, int n6) throws ChartDataException {
        Point2D.Double[] doubleArray = new Point2D.Double[20];
        for (int i = 0; i < 20; ++i) {
            doubleArray[i] = new Point2D.Double();
            doubleArray[i].setLocation(i, Math.pow(i, 2.0));
        }
        String[] stringArray = TestDataGenerator.getRandomStrings(1, 12, false);
        Paint paint = TestDataGenerator.getRandomPaint();
        ScatterPlotDataSet scatterPlotDataSet = new ScatterPlotDataSet(this.getScatterPlotProperties(1));
        scatterPlotDataSet.addDataPoints(doubleArray, paint, stringArray[0]);
        System.out.println("legendLabels[ 0 ]= " + stringArray[0]);
        return scatterPlotDataSet;
    }

    DataSeries getDataSeries() throws ChartDataException {
        DataSeries dataSeries = null;
        int n = (int)TestDataGenerator.getRandomNumber(3.0, 3.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 1.0);
        String string = TestDataGenerator.getRandomString(15, true);
        String string2 = TestDataGenerator.getRandomString(15, true);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        ScatterPlotTestDriver scatterPlotTestDriver = new ScatterPlotTestDriver();
        ScatterPlotDataSet scatterPlotDataSet = scatterPlotTestDriver.createScatterPlotDataSet(1, 5, -1000, 3000, 200, 500);
        ScatterPlotDataSeries scatterPlotDataSeries = new ScatterPlotDataSeries(scatterPlotDataSet, "X-Axis Title", "Y-Axis Title", "Chart Title");
        DataAxisProperties dataAxisProperties = new DataAxisProperties();
        dataAxisProperties.setUserDefinedScale(-5.0, 3.0);
        dataAxisProperties.setNumItems(10);
        dataAxisProperties.setRoundToNearest(0);
        DataAxisProperties dataAxisProperties2 = new DataAxisProperties();
        dataAxisProperties2.setUserDefinedScale(-30.0, 50.0);
        dataAxisProperties2.setNumItems(10);
        dataAxisProperties2.setRoundToNearest(1);
        AxisProperties axisProperties = new AxisProperties(dataAxisProperties, dataAxisProperties2);
        ChartProperties chartProperties = new ChartProperties();
        LegendProperties legendProperties = new LegendProperties();
        ScatterPlotAxisChart scatterPlotAxisChart = new ScatterPlotAxisChart(scatterPlotDataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(scatterPlotAxisChart, "ScatterPlotTest.png");
    }
}

