/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.axisChart.AreaChart;
import org.krysalis.jcharts.axisChart.BarChart;
import org.krysalis.jcharts.axisChart.ClusteredBarChart;
import org.krysalis.jcharts.axisChart.LineChart;
import org.krysalis.jcharts.axisChart.PointChart;
import org.krysalis.jcharts.axisChart.StackedAreaChart;
import org.krysalis.jcharts.axisChart.StackedBarChart;
import org.krysalis.jcharts.axisChart.StockChart;
import org.krysalis.jcharts.axisChart.axis.Axis;
import org.krysalis.jcharts.axisChart.axis.XAxis;
import org.krysalis.jcharts.axisChart.axis.YAxis;
import org.krysalis.jcharts.axisChart.axis.scale.AutomaticScaleCalculator;
import org.krysalis.jcharts.axisChart.axis.scale.ScaleCalculator;
import org.krysalis.jcharts.axisChart.axis.scale.UserDefinedScaleCalculator;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.chartData.interfaces.IAxisDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IStockChartDataSet;
import org.krysalis.jcharts.chartData.processors.AxisChartDataProcessor;
import org.krysalis.jcharts.chartText.NumericTagGroup;
import org.krysalis.jcharts.chartText.TextTagGroup;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.AxisTypeProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLChartTestable;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;
import org.krysalis.jcharts.types.ChartType;

public class AxisChart
extends Chart
implements HTMLChartTestable {
    protected XAxis xAxis;
    protected YAxis yAxis;
    protected AxisProperties axisProperties;
    private IAxisDataSeries iAxisDataSeries;

    public AxisChart(IAxisDataSeries iAxisDataSeries, ChartProperties chartProperties, AxisProperties axisProperties, LegendProperties legendProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.axisProperties = axisProperties;
        this.iAxisDataSeries = iAxisDataSeries;
    }

    public IAxisDataSeries getIAxisDataSeries() {
        return this.iAxisDataSeries;
    }

    public AxisChartDataProcessor createAxisChartDataProcessor() {
        return new AxisChartDataProcessor();
    }

    protected NumericTagGroup setupDataAxisProperties(Axis axis, DataAxisProperties dataAxisProperties, AxisChartDataProcessor axisChartDataProcessor, FontRenderContext fontRenderContext) {
        Object object;
        if (dataAxisProperties.getScaleCalculator() == null) {
            if (dataAxisProperties.hasUserDefinedScale()) {
                object = new UserDefinedScaleCalculator(dataAxisProperties.getUserDefinedMinimumValue(), dataAxisProperties.getUserDefinedIncrement());
            } else {
                object = new AutomaticScaleCalculator();
                if (this.axisProperties.getYAxisProperties().getMaxRightAxis() > 0.0) {
                    ((ScaleCalculator)object).setMaxValue(this.axisProperties.getYAxisProperties().getMaxRightAxis());
                } else {
                    ((ScaleCalculator)object).setMaxValue(axisChartDataProcessor.getMaxValue());
                }
                if (this.axisProperties.getYAxisProperties().getMinRightAxis() < 0.0) {
                    ((ScaleCalculator)object).setMinValue(this.axisProperties.getYAxisProperties().getMinRightAxis());
                } else {
                    ((ScaleCalculator)object).setMinValue(axisChartDataProcessor.getMinValue());
                }
            }
            axis.setScaleCalculator((ScaleCalculator)object);
        } else {
            axis.setScaleCalculator(dataAxisProperties.getScaleCalculator());
            if (this.axisProperties.getYAxisProperties().getMaxRightAxis() > 0.0) {
                axis.getScaleCalculator().setMaxValue(this.axisProperties.getYAxisProperties().getMaxRightAxis());
            } else {
                axis.getScaleCalculator().setMaxValue(axisChartDataProcessor.getMaxValue());
            }
            if (this.axisProperties.getYAxisProperties().getMinRightAxis() < 0.0) {
                axis.getScaleCalculator().setMinValue(this.axisProperties.getYAxisProperties().getMinRightAxis());
            } else {
                axis.getScaleCalculator().setMinValue(axisChartDataProcessor.getMinValue());
            }
        }
        axis.getScaleCalculator().setRoundingPowerOfTen(dataAxisProperties.getRoundToNearest());
        axis.getScaleCalculator().setNumberOfScaleItems(dataAxisProperties.getNumItems());
        axis.getScaleCalculator().computeScaleValues();
        object = new NumericTagGroup(dataAxisProperties.getScaleChartFont(), fontRenderContext, dataAxisProperties.useDollarSigns(), dataAxisProperties.usePercentSigns(), dataAxisProperties.useCommas(), dataAxisProperties.getRoundToNearest());
        ((NumericTagGroup)object).createAxisScaleLabels(axis.getScaleCalculator());
        return object;
    }

    protected void setupAxis(AxisChartDataProcessor axisChartDataProcessor, FontRenderContext fontRenderContext) throws ChartDataException {
        IDataSeries iDataSeries = (IDataSeries)this.getIAxisDataSeries();
        if (this.axisProperties.isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)this.getAxisProperties().getXAxisProperties();
            this.xAxis = new XAxis(this, dataAxisProperties.getNumItems());
            NumericTagGroup numericTagGroup = this.setupDataAxisProperties(this.xAxis, dataAxisProperties, axisChartDataProcessor, fontRenderContext);
            this.xAxis.setAxisLabelsGroup(numericTagGroup);
            AxisTypeProperties axisTypeProperties = this.getAxisProperties().getYAxisProperties();
            this.yAxis = new YAxis(this, axisChartDataProcessor.getNumberOfElementsInADataSet());
            if (axisTypeProperties.showAxisLabels()) {
                TextTagGroup textTagGroup = new TextTagGroup(axisTypeProperties.getScaleChartFont(), fontRenderContext);
                for (int i = 0; i < iDataSeries.getNumberOfAxisLabels(); ++i) {
                    if (iDataSeries.getAxisLabel(i) == null) {
                        throw new ChartDataException("None of the axis labels can be NULL.");
                    }
                    textTagGroup.addLabel(iDataSeries.getAxisLabel(i));
                }
                this.yAxis.setAxisLabelsGroup(textTagGroup);
            }
        } else {
            HTMLTestable hTMLTestable;
            AxisTypeProperties axisTypeProperties = this.getAxisProperties().getXAxisProperties();
            this.xAxis = new XAxis(this, axisChartDataProcessor.getNumberOfElementsInADataSet());
            if (axisTypeProperties.showAxisLabels()) {
                hTMLTestable = new TextTagGroup(axisTypeProperties.getScaleChartFont(), fontRenderContext);
                for (int i = 0; i < iDataSeries.getNumberOfAxisLabels(); ++i) {
                    if (iDataSeries.getAxisLabel(i) == null) {
                        throw new ChartDataException("None of the axis labels can be NULL.");
                    }
                    ((TextTagGroup)hTMLTestable).addLabel(iDataSeries.getAxisLabel(i));
                }
                this.xAxis.setAxisLabelsGroup((TextTagGroup)hTMLTestable);
            }
            hTMLTestable = (DataAxisProperties)this.getAxisProperties().getYAxisProperties();
            this.yAxis = new YAxis(this, ((DataAxisProperties)hTMLTestable).getNumItems());
            NumericTagGroup numericTagGroup = this.setupDataAxisProperties(this.yAxis, (DataAxisProperties)hTMLTestable, axisChartDataProcessor, fontRenderContext);
            this.yAxis.setAxisLabelsGroup(numericTagGroup);
            if (this.axisProperties.getYAxisProperties().getSecondScaleRight() != 1.0f) {
                NumericTagGroup numericTagGroup2 = new NumericTagGroup(((AxisTypeProperties)hTMLTestable).getScaleChartFontRight(), fontRenderContext, ((DataAxisProperties)hTMLTestable).useDollarSigns(), ((DataAxisProperties)hTMLTestable).usePercentSigns(), ((DataAxisProperties)hTMLTestable).useCommas(), ((DataAxisProperties)hTMLTestable).getRoundToNearest());
                for (int i = 0; i < this.getYAxis().getNumberOfScaleItems(); ++i) {
                    Float f = new Float(this.yAxis.getAxisLabelsGroup().getTextTag(i).getText());
                    float f2 = f.floatValue();
                    String string = new String(String.valueOf(Math.round(f2 / this.axisProperties.getYAxisProperties().getSecondScaleRight())));
                    numericTagGroup2.addLabel(string);
                }
                this.yAxis.setAxisLabelsGroupRight(numericTagGroup2);
            }
        }
        this.yAxis.computeMinimumWidthNeeded(iDataSeries.getYAxisTitle());
        this.xAxis.computeMinimumHeightNeeded(iDataSeries.getXAxisTitle());
    }

    private void sizeAndPositionAxis(float f, float f2, float f3) {
        f = this.axisProperties.getYAxisProperties().getShowRightAxis() ? (f -= 2.0f * this.yAxis.getMinimumWidthNeeded()) : (f -= this.yAxis.getMinimumWidthNeeded());
        f2 -= this.xAxis.getMinimumHeightNeeded();
        this.xAxis.setPixelLength(f);
        if (this.axisProperties.getYAxisProperties().showAxisLabels()) {
            this.yAxis.setPixelLength(f2 - this.yAxis.getAxisLabelsGroup().getTallestLabel() / 2.0f);
        } else {
            this.yAxis.setPixelLength(f2);
        }
        if (this.getLegend() != null) {
            if (this.getLegend().getLegendProperties().getPlacement() == 1 || this.getLegend().getLegendProperties().getPlacement() == 0) {
                this.xAxis.setOrigin(this.yAxis.getMinimumWidthNeeded() + super.getChartProperties().getEdgePadding());
                this.yAxis.setOrigin(f2 + super.getChartProperties().getEdgePadding() + f3);
            } else if (this.getLegend().getLegendProperties().getPlacement() == 2) {
                this.xAxis.setOrigin((float)super.getImageWidth() - f - super.getChartProperties().getEdgePadding());
                this.yAxis.setOrigin(f2 + super.getChartProperties().getEdgePadding() + f3);
            } else if (this.getLegend().getLegendProperties().getPlacement() == 3) {
                this.xAxis.setOrigin(this.yAxis.getMinimumWidthNeeded() + super.getChartProperties().getEdgePadding());
                this.yAxis.setOrigin((float)super.getImageHeight() - super.getChartProperties().getEdgePadding() - this.xAxis.getMinimumHeightNeeded());
            }
        } else {
            this.xAxis.setOrigin(this.yAxis.getMinimumWidthNeeded() + super.getChartProperties().getEdgePadding());
            this.yAxis.setOrigin(f2 + super.getChartProperties().getEdgePadding() + f3);
        }
    }

    protected void deriveAxisValues() {
        this.xAxis.computeLabelFilter();
        this.xAxis.computeShouldTickStartAtYAxis(this.iAxisDataSeries, this.axisProperties.getXAxisProperties());
        if (this.axisProperties.isPlotHorizontal()) {
            this.xAxis.computeScalePixelWidthDataAxis(this.axisProperties.getXAxisProperties());
            this.yAxis.computeScalePixelWidth(this.axisProperties.getYAxisProperties());
            this.xAxis.computeOneUnitPixelSize(this.xAxis.getScalePixelWidth(), this.xAxis.getScaleCalculator().getIncrement());
            float f = (float)((double)this.xAxis.getOrigin() + (double)this.xAxis.getScalePixelWidth() * -this.xAxis.getScaleCalculator().getMinValue() / this.xAxis.getScaleCalculator().getIncrement());
            this.xAxis.setZeroLineCoordinate(f);
        } else {
            this.xAxis.computeScalePixelWidth(this.axisProperties.getXAxisProperties());
            this.yAxis.computeScalePixelWidthDataAxis(this.axisProperties.getYAxisProperties());
            this.yAxis.computeOneUnitPixelSize(this.yAxis.getScalePixelWidth(), this.yAxis.getScaleCalculator().getIncrement());
            float f = (float)((double)this.yAxis.getOrigin() - (double)this.yAxis.getScalePixelWidth() * -this.yAxis.getScaleCalculator().getMinValue() / this.yAxis.getScaleCalculator().getIncrement());
            this.yAxis.setZeroLineCoordinate(f);
        }
        this.xAxis.computeTickStart();
    }

    protected void renderChart() throws ChartDataException, PropertyException {
        Rectangle2D.Float float_;
        if (super.getChartProperties().validate()) {
            this.iAxisDataSeries.validate();
        }
        this.validateHorizontalPlot();
        Graphics2D graphics2D = super.getGraphics2D();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        float f = super.getChartProperties().getEdgePadding() * 2.0f;
        float f2 = (float)super.getImageWidth() - f;
        float f3 = (float)super.getImageHeight() - f;
        float f4 = super.renderChartTitle(this.getIAxisDataSeries().getChartTitle(), fontRenderContext);
        f3 -= f4;
        if (super.getLegend() != null) {
            super.getLegend().computeLegendXY(this.iAxisDataSeries, f4);
            if (super.getLegend().getLegendProperties().getPlacement() == 1 || super.getLegend().getLegendProperties().getPlacement() == 2) {
                f2 -= (float)super.getLegend().getLegendProperties().getChartPadding();
                f2 -= super.getLegend().getWidth();
            } else {
                f3 -= (float)this.getLegend().getLegendProperties().getChartPadding();
                f3 -= (float)this.getLegend().getHeight();
            }
            super.getLegend().render();
        }
        AxisChartDataProcessor axisChartDataProcessor = this.createAxisChartDataProcessor();
        axisChartDataProcessor.processData(this, fontRenderContext);
        this.setupAxis(axisChartDataProcessor, fontRenderContext);
        this.sizeAndPositionAxis(f2, f3, f4);
        this.deriveAxisValues();
        if (this.getAxisProperties().getBackgroundPaint() != null) {
            float_ = new Rectangle2D.Float(this.xAxis.getOrigin() + 1.0f, this.yAxis.getOrigin() - this.yAxis.getPixelLength(), this.xAxis.getPixelLength(), this.yAxis.getPixelLength());
            graphics2D.setPaint(this.axisProperties.getBackgroundPaint());
            graphics2D.fill(float_);
        }
        this.yAxis.render(graphics2D, this.getAxisProperties(), this.iAxisDataSeries.getYAxisTitle());
        this.xAxis.render(graphics2D, this.getAxisProperties(), this.iAxisDataSeries.getXAxisTitle());
        float_ = new Rectangle2D.Float(this.getXAxis().getOrigin(), this.getYAxis().getOrigin() - this.getYAxis().getPixelLength() + 1.0f, this.xAxis.getPixelLength() + 1.0f, this.yAxis.getPixelLength() - 2.0f);
        graphics2D.setClip(float_);
        if (super.getGenerateImageMapFlag()) {
            ImageMap imageMap = new ImageMap(this.iAxisDataSeries.size() * this.iAxisDataSeries.getTotalNumberOfDataSets());
            super.setImageMap(imageMap);
        }
        this.overlayCharts();
    }

    protected void overlayCharts() throws PropertyException, ChartDataException {
        IAxisPlotDataSet iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.AREA_STACKED);
        if (iAxisPlotDataSet != null) {
            StackedAreaChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.AREA)) != null) {
            AreaChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR)) != null) {
            BarChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR_STACKED)) != null) {
            StackedBarChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR_CLUSTERED)) != null) {
            ClusteredBarChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.STOCK)) != null) {
            StockChart.render(this, (IStockChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.LINE)) != null) {
            LineChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
        if ((iAxisPlotDataSet = this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.POINT)) != null) {
            PointChart.render(this, (IAxisChartDataSet)iAxisPlotDataSet);
        }
    }

    private void validateHorizontalPlot() throws PropertyException {
        if (this.axisProperties.isPlotHorizontal()) {
            if (this.iAxisDataSeries.size() > 1) {
                throw new PropertyException("You can not have a combo chart on a horizontal plot.");
            }
            if (!this.allowHorizontalPlot()) {
                throw new PropertyException("Horizontal plots are only supported in the Bar, Stacked Bar, and Clustered Bar Chart Types.");
            }
        }
    }

    private boolean allowHorizontalPlot() {
        if (this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR) != null) {
            return true;
        }
        if (this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR_STACKED) != null) {
            return true;
        }
        return this.iAxisDataSeries.getIAxisPlotDataSet(ChartType.BAR_CLUSTERED) != null;
    }

    public AxisProperties getAxisProperties() {
        return this.axisProperties;
    }

    public XAxis getXAxis() {
        return this.xAxis;
    }

    public YAxis getYAxis() {
        return this.yAxis;
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string, ImageMap imageMap) {
        hTMLGenerator.chartTableStart(this.getClass().getName(), string, imageMap);
        if (this.iAxisDataSeries instanceof HTMLTestable) {
            ((HTMLTestable)((Object)this.iAxisDataSeries)).toHTML(hTMLGenerator);
        }
        hTMLGenerator.chartTableRowStart();
        this.axisProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.xAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.yAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        super.getChartProperties().toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        if (super.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

