/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData;

import java.util.Iterator;
import org.krysalis.jcharts.chartData.AxisDataSeries;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;

public class DataSeries
extends AxisDataSeries
implements IDataSeries,
HTMLTestable {
    private String[] axisLabels;

    public DataSeries(String[] stringArray, String string, String string2, String string3) {
        super(string, string2, string3);
        this.axisLabels = stringArray;
    }

    public String getAxisLabel(int n) {
        return this.axisLabels[n];
    }

    public int getNumberOfAxisLabels() {
        if (this.axisLabels != null) {
            return this.axisLabels.length;
        }
        return 0;
    }

    public void validate() throws ChartDataException, PropertyException {
        super.validate();
        if (this.axisLabels != null && this.axisLabels.length != super.getSizeOfEachDataSet()) {
            throw new ChartDataException("The size of the Axis Labels Array does not match the number of data elements to be plotted.");
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableRowStart();
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        hTMLGenerator.addTableRow("xAxisLabels", HTMLGenerator.arrayToString(this.axisLabels));
        hTMLGenerator.addTableRow("totalNumberOfDataSets", Integer.toString(this.totalNumberOfDataSets));
        hTMLGenerator.propertiesTableEnd();
        hTMLGenerator.propertiesTableRowEnd();
        hTMLGenerator.propertiesTableRowStart();
        Iterator iterator = this.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof HTMLTestable)) continue;
            ((HTMLTestable)e).toHTML(hTMLGenerator);
        }
        hTMLGenerator.propertiesTableRowEnd();
    }
}

