/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.wrapper;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationTrustResolver;
import org.springframework.security.AuthenticationTrustResolverImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.util.PortResolver;

public class SecurityContextHolderAwareRequestWrapper
extends HttpServletRequestWrapper {
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private String rolePrefix;

    public SecurityContextHolderAwareRequestWrapper(HttpServletRequest request, PortResolver portResolver, String rolePrefix) {
        super(request);
        this.rolePrefix = rolePrefix;
    }

    private Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!this.authenticationTrustResolver.isAnonymous(auth)) {
            return auth;
        }
        return null;
    }

    public String getRemoteUser() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    public Principal getUserPrincipal() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        return auth;
    }

    private boolean isGranted(String role) {
        Authentication auth = this.getAuthentication();
        if (this.rolePrefix != null) {
            role = this.rolePrefix + role;
        }
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        for (int i = 0; i < auth.getAuthorities().length; ++i) {
            if (!role.equals(auth.getAuthorities()[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInRole(String role) {
        return this.isGranted(role);
    }
}

