/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.http.HTTPHeaderElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class HTTPHeaderDeserializer
implements ExtensionDeserializer {
    public ExtensionElement unmarshall(Class parentType, Object parent, QName extType, XMLElement extEl, DescriptionElement desc, ExtensionRegistry extReg) throws WSDLException {
        HTTPHeaderElement httpHdr = (HTTPHeaderElement)extReg.createExtElement(parentType, extType);
        httpHdr.setExtensionType(extType);
        httpHdr.setParentElement((WSDLElement)parent);
        String name = extEl.getAttributeValue("name");
        httpHdr.setName(name);
        String typeQN = extEl.getAttributeValue("type");
        if (typeQN != null) {
            try {
                QName qname = extEl.getQName(typeQN);
                httpHdr.setTypeName(qname);
            }
            catch (WSDLException e) {
                extReg.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{typeQN, extEl.getLocalName()}, (short)2);
            }
        }
        String required = extEl.getAttributeValue("required");
        httpHdr.setRequired(new Boolean(required));
        return httpHdr;
    }

    private DocumentationElement parseDocumentation(XMLElement docEl, DocumentableElement parent) throws WSDLException {
        DocumentationElement documentation = parent.addDocumentationElement();
        documentation.setContent(docEl);
        return documentation;
    }
}

