/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.LifecycleImpl;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    static final int FIRST_PHASE = PhaseId.RESTORE_VIEW.getOrdinal();
    static final int LAST_PHASE = PhaseId.RENDER_RESPONSE.getOrdinal();
    protected static Log log = LogFactory.getLog((Class)(class$com$sun$faces$lifecycle$LifecycleFactoryImpl == null ? (class$com$sun$faces$lifecycle$LifecycleFactoryImpl = LifecycleFactoryImpl.class$("com.sun.faces.lifecycle.LifecycleFactoryImpl")) : class$com$sun$faces$lifecycle$LifecycleFactoryImpl));
    protected HashMap lifecycleMap = new HashMap();
    protected Object lock = null;
    static /* synthetic */ Class class$com$sun$faces$lifecycle$LifecycleFactoryImpl;

    public LifecycleFactoryImpl() {
        this.lifecycleMap.put("DEFAULT", new LifecycleWrapper(new LifecycleImpl(), false));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created Default Lifecycle");
        }
        this.lock = new Object();
    }

    boolean alreadyCreated(String lifecycleId) {
        LifecycleWrapper wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        return null != wrapper && wrapper.created;
    }

    Lifecycle verifyRegisterArgs(String lifecycleId, int phaseId, Phase phase) {
        String message = null;
        LifecycleWrapper wrapper = null;
        Lifecycle result = null;
        Object[] params = new Object[]{lifecycleId};
        if (null == lifecycleId || null == phase) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        if (null == wrapper) {
            message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_NOT_FOUND", params);
            if (log.isErrorEnabled()) {
                log.error((Object)("Error: " + message));
            }
            throw new IllegalArgumentException(message);
        }
        result = wrapper.instance;
        Util.doAssert(null != result);
        if (this.alreadyCreated(lifecycleId)) {
            message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            if (log.isErrorEnabled()) {
                log.error((Object)("Error: " + message));
            }
            throw new IllegalStateException(message);
        }
        if (FIRST_PHASE > phaseId || phaseId > LAST_PHASE) {
            params = new Object[]{Integer.toString(phaseId)};
            message = Util.getExceptionMessageString("com.sun.faces.PHASE_ID_OUT_OF_BOUNDS", params);
            if (log.isErrorEnabled()) {
                log.error((Object)("Error: " + message));
            }
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null || lifecycle == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null != this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            if (log.isErrorEnabled()) {
                log.error((Object)("addLifecycle: " + message));
            }
            throw new IllegalArgumentException(message);
        }
        this.lifecycleMap.put(lifecycleId, new LifecycleWrapper(lifecycle, false));
        if (log.isDebugEnabled()) {
            log.debug((Object)("addedLifecycle: " + lifecycleId + " " + lifecycle));
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        Lifecycle result = null;
        LifecycleWrapper wrapper = null;
        if (null == lifecycleId) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null == this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = Util.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", params);
            if (log.isErrorEnabled()) {
                log.error((Object)("LifecycleId " + lifecycleId + " does not exist"));
            }
            throw new IllegalArgumentException(message);
        }
        wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        result = wrapper.instance;
        wrapper.created = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLifecycle: " + lifecycleId + " " + result));
        }
        return result;
    }

    public Iterator getLifecycleIds() {
        return this.lifecycleMap.keySet().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LifecycleWrapper {
        Lifecycle instance = null;
        boolean created = false;

        LifecycleWrapper(Lifecycle newInstance, boolean newCreated) {
            this.instance = newInstance;
            this.created = newCreated;
        }
    }
}

