/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.mex;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.mex.MexDisabledException;
import org.apache.axis2.mex.MexException;
import org.apache.axis2.mex.om.Location;
import org.apache.axis2.mex.om.Metadata;
import org.apache.axis2.mex.om.MetadataReference;
import org.apache.axis2.mex.om.MetadataSection;
import org.apache.axis2.mex.om.MexOMException;
import org.apache.axis2.mex.util.MexUtil;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MexMessageReceiver
extends AbstractInOutMessageReceiver {
    private static final Log log = LogFactory.getLog(MexMessageReceiver.class);
    Parameter axisConfigMEXParm = null;
    Parameter serviceConfigMEXParm = null;
    String mexNamespaceValue = null;

    public void invokeBusinessLogic(MessageContext msgContext, MessageContext newmsgContext) throws AxisFault {
        AxisService theService = msgContext.getAxisService();
        this.axisConfigMEXParm = msgContext.getConfigurationContext().getAxisConfiguration().getParameter("metadataExchange");
        this.serviceConfigMEXParm = theService.getParameter("metadataExchange");
        this.check_MEX_disabled(this.serviceConfigMEXParm);
        try {
            Metadata metadata = this.handleRequest(msgContext);
            theService.setEndpointURL(msgContext.getTo().getAddress());
            if (metadata != null) {
                OMElement result;
                SOAPEnvelope envelope = newmsgContext.getEnvelope();
                if (envelope == null) {
                    SOAPFactory fac = this.getSOAPFactory(msgContext);
                    envelope = fac.getDefaultEnvelope();
                }
                if ((result = metadata.toOM()) != null) {
                    AxisService service = msgContext.getAxisService();
                    result.declareNamespace(service.getTargetNamespace(), service.getTargetNamespacePrefix());
                    envelope.getBody().addChild((OMNode)result);
                }
                newmsgContext.setEnvelope(envelope);
            }
        }
        catch (Exception e) {
            log.info((Object)e);
            if (e instanceof MexException) {
                throw (MexException)((Object)e);
            }
            throw new MexException(e);
        }
    }

    private Metadata handleRequest(MessageContext msgContext) throws AxisFault {
        Metadata metadata = null;
        SOAPEnvelope envelope = msgContext.getEnvelope();
        SOAPBody body = envelope.getBody();
        OMElement aReq = body.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/mex", "GetMetadata"));
        if (aReq == null) {
            throw new MexException("Invalid Metadata request");
        }
        this.mexNamespaceValue = "http://schemas.xmlsoap.org/ws/2004/09/mex";
        List metadata_request_list = this.determineMetadataTypes(aReq);
        metadata = this.processRequest(metadata_request_list, msgContext, aReq);
        return metadata;
    }

    public Metadata processRequest(List metadata_request_list, MessageContext msgContext, OMElement aReq) throws MexException {
        OMElement identifier;
        SOAPEnvelope envelope = msgContext.getEnvelope();
        String soapNamespaceURI = envelope.getNamespace().getNamespaceURI();
        SOAPFactory factory = MexUtil.getSOAPFactory(soapNamespaceURI);
        Metadata metadata = new Metadata((OMFactory)factory, this.mexNamespaceValue);
        DataRetrievalRequest requestOptions = new DataRetrievalRequest();
        String identifier_value = null;
        OMElement dialectElem = aReq.getFirstChildWithName(new QName(this.mexNamespaceValue, "Dialect"));
        if (dialectElem != null && (identifier = dialectElem.getFirstChildWithName(new QName(this.mexNamespaceValue, "Identifier"))) != null && (identifier_value = identifier.getText()) != null && identifier_value.length() > 0) {
            requestOptions.putIdentifier(identifier_value);
        }
        int len = metadata_request_list.size();
        for (int i = 0; i < len; ++i) {
            String dialect = "";
            try {
                dialect = (String)metadata_request_list.get(i);
                requestOptions.putDialect(dialect);
                OutputForm[] outputforms = MexUtil.determineOutputForm(dialect, this.axisConfigMEXParm, this.serviceConfigMEXParm);
                for (int j = 0; j < outputforms.length; ++j) {
                    requestOptions.putOutputForm(outputforms[j]);
                    Data[] result = msgContext.getAxisService().getData(requestOptions, msgContext);
                    ArrayList sections = this.processData(result, outputforms[j], dialect, identifier_value, factory);
                    metadata.addMetadatSections(sections);
                }
                continue;
            }
            catch (DataRetrievalException e) {
                log.error((Object)("Data Retrieval exception detected for dialect, " + dialect), (Throwable)e);
                throw new MexException(e);
            }
            catch (Throwable e) {
                log.error((Object)("Throwable detected for dialect, " + dialect), e);
                e.printStackTrace();
                throw new MexException(e);
            }
        }
        return metadata;
    }

    private ArrayList processData(Data[] data, OutputForm outputForm, String dialect, String identifier_value, SOAPFactory factory) throws MexException {
        MetadataSection section = null;
        ArrayList<MetadataSection> sections = new ArrayList<MetadataSection>();
        if (data == null || data.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No result was returned from getData request for dialect," + dialect + " Form: " + outputForm.getType() + ". No MetadataSection will be added!"));
            }
        } else {
            for (int k = 0; k < data.length; ++k) {
                section = this.createMetadataSection(outputForm, data[k].getData(), factory, this.mexNamespaceValue);
                section.setDialect(dialect);
                identifier_value = data[k].getIdentifier();
                if (identifier_value != null) {
                    section.setIdentifier(identifier_value);
                }
                sections.add(section);
            }
        }
        return sections;
    }

    private MetadataSection createMetadataSection(OutputForm outputForm, Object result, SOAPFactory factory, String mexNamespaceValue) throws MexOMException {
        MetadataSection section = new MetadataSection((OMFactory)factory, mexNamespaceValue);
        if (outputForm == OutputForm.INLINE_FORM) {
            section.setinlineData(result);
        } else if (outputForm == OutputForm.LOCATION_FORM) {
            section.setLocation(new Location((OMFactory)factory, mexNamespaceValue, (String)result));
        } else if (outputForm == OutputForm.REFERENCE_FORM) {
            MetadataReference ref = new MetadataReference((OMFactory)factory, mexNamespaceValue);
            ref.setEPR((OMElement)result);
            section.setMetadataReference(ref);
        } else {
            section.setinlineData((OMElement)result);
        }
        return section;
    }

    private List determineMetadataTypes(OMElement aReq) {
        ArrayList<String> metadata_request_list = new ArrayList<String>();
        boolean allTypes = false;
        OMElement dialect = aReq.getFirstChildWithName(new QName(this.mexNamespaceValue, "Dialect"));
        if (dialect != null) {
            String dialectText = dialect.getText();
            if (dialectText != null && dialectText.length() > 0) {
                metadata_request_list.add(dialectText.trim());
            } else {
                allTypes = true;
            }
        } else {
            allTypes = true;
        }
        if (allTypes) {
            metadata_request_list.add("http://schemas.xmlsoap.org/ws/2004/09/policy");
            metadata_request_list.add("http://www.w3.org/2001/XMLSchema");
            metadata_request_list.add("http://schemas.xmlsoap.org/wsdl/");
        }
        return metadata_request_list;
    }

    private void check_MEX_disabled(Parameter mexConfig) throws MexDisabledException {
        if (MexUtil.isMexDisabled(mexConfig)) {
            throw new MexDisabledException("'metadataexchange' parameter configured to disable MEX for the service.");
        }
    }
}

