/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.interfaces.IAxisDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IData;
import org.krysalis.jcharts.chartData.interfaces.IPieChartDataSet;
import org.krysalis.jcharts.chartData.processors.TextProcessor;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;
import org.krysalis.jcharts.types.ChartType;

public final class Legend
implements HTMLTestable,
Serializable {
    private Chart chart;
    private LegendProperties legendProperties;
    private float iconSide;
    private float widestLabelAndColumnPadding;
    private int numColumns;
    private int numRows;
    private TextProcessor textProcessor;
    private float x;
    private float y;
    private float width = 0.0f;
    private float height = 0.0f;
    private ArrayList labels;
    private ArrayList paints;
    private ArrayList shapes = new ArrayList();
    private ArrayList fillPointsFlags = new ArrayList();
    private ArrayList pointOutlinePaints = new ArrayList();
    private ChartType chartType;
    private PointChartProperties pointChartProperties;
    private LineChartProperties lineChartProperties;

    public Legend(Chart chart) {
        this.chart = chart;
    }

    public Legend(Chart chart, LegendProperties legendProperties) {
        this.chart = chart;
        this.legendProperties = legendProperties;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void computeLegendXY(IAxisDataSeries iAxisDataSeries, float f) {
        this.calculateDrawingValues(iAxisDataSeries);
        if (this.getLegendProperties().getPlacement() == 1 || this.getLegendProperties().getPlacement() == 2) {
            if ((float)this.getHeight() > (float)this.chart.getImageHeight() - this.chart.getChartProperties().getEdgePadding() * 2.0f) {
                this.setY(this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setY(this.chart.getImageHeight() / 2 - this.getHeight() / 2);
            }
            if (this.getLegendProperties().getPlacement() == 1) {
                this.setX((float)this.chart.getImageWidth() - this.getWidth() - this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setX(this.chart.getChartProperties().getEdgePadding());
            }
        } else {
            if (this.getWidth() + this.chart.getChartProperties().getEdgePadding() * 2.0f > (float)this.chart.getImageWidth()) {
                this.setX(this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setX((float)(this.chart.getImageWidth() / 2) - this.getWidth() / 2.0f);
            }
            if (this.getLegendProperties().getPlacement() == 0) {
                this.setY((float)(this.chart.getImageHeight() - this.getHeight()) - this.chart.getChartProperties().getEdgePadding());
            } else {
                this.setY(this.chart.getChartProperties().getEdgePadding() + f);
            }
        }
    }

    private void processData(IAxisDataSeries iAxisDataSeries) {
        this.textProcessor = new TextProcessor();
        Iterator iterator = iAxisDataSeries.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            this.processLegendLabels((IAxisPlotDataSet)iterator.next());
        }
    }

    private void processData(IPieChartDataSet iPieChartDataSet) {
        this.textProcessor = new TextProcessor();
        this.processLegendLabels(iPieChartDataSet);
    }

    private void processLegendLabels(IAxisPlotDataSet iAxisPlotDataSet) {
        for (int i = 0; i < iAxisPlotDataSet.getNumberOfLegendLabels(); ++i) {
            if (iAxisPlotDataSet.getLegendLabel(i) == null) continue;
            this.textProcessor.addLabel(iAxisPlotDataSet.getLegendLabel(i), this.legendProperties.getChartFont().getFont(), this.chart.getGraphics2D().getFontRenderContext());
            this.labels.add(iAxisPlotDataSet.getLegendLabel(i));
            this.paints.add(iAxisPlotDataSet.getPaint(i));
            if (iAxisPlotDataSet.getChartType().equals(ChartType.POINT)) {
                this.chartType = ChartType.POINT;
                this.pointChartProperties = (PointChartProperties)iAxisPlotDataSet.getChartTypeProperties();
                this.shapes.add(this.pointChartProperties.getShape(i));
                this.fillPointsFlags.add(new Boolean(this.pointChartProperties.getFillPointsFlag(i)));
                this.pointOutlinePaints.add(this.pointChartProperties.getPointOutlinePaints(i));
            }
            if (!iAxisPlotDataSet.getChartType().equals(ChartType.LINE)) continue;
            this.chartType = ChartType.LINE;
            this.lineChartProperties = (LineChartProperties)iAxisPlotDataSet.getChartTypeProperties();
            if (this.lineChartProperties.getShapes() == null) continue;
            this.shapes.add(this.lineChartProperties.getShapes()[i]);
        }
    }

    private void processLegendLabels(IPieChartDataSet iPieChartDataSet) {
        for (int i = 0; i < iPieChartDataSet.getNumberOfLegendLabels(); ++i) {
            if (iPieChartDataSet.getLegendLabel(i) == null) continue;
            this.textProcessor.addLabel(iPieChartDataSet.getLegendLabel(i), this.legendProperties.getChartFont().getFont(), this.chart.getGraphics2D().getFontRenderContext());
            this.labels.add(iPieChartDataSet.getLegendLabel(i));
            this.paints.add(iPieChartDataSet.getPaint(i));
        }
    }

    public LegendProperties getLegendProperties() {
        return this.legendProperties;
    }

    public void calculateDrawingValues(IData iData) {
        int n;
        IData iData2;
        this.labels = new ArrayList();
        this.paints = new ArrayList();
        if (iData instanceof IAxisDataSeries) {
            iData2 = (IAxisDataSeries)iData;
            this.processData((IAxisDataSeries)iData2);
            n = iData2.getTotalNumberOfDataSets();
        } else {
            iData2 = (IPieChartDataSet)iData;
            this.processData((IPieChartDataSet)iData2);
            n = iData2.getNumberOfLegendLabels();
        }
        this.iconSide = 0.5f * this.textProcessor.getTallestLabel();
        if (this.chartType == ChartType.POINT || this.chartType == ChartType.LINE) {
            for (int i = 0; i < this.shapes.size(); ++i) {
                try {
                    Double d = new Double(((Shape)this.shapes.get(i)).getBounds2D().getWidth());
                    float f = d.floatValue();
                    this.iconSide = Math.max(this.iconSide, f);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    System.err.println("Warning: legend shape is null");
                    nullPointerException.printStackTrace();
                }
            }
        }
        this.determineWidthAndHeight(n);
    }

    public float getWidth() {
        return this.width;
    }

    public int getHeight() {
        return (int)Math.ceil(this.height);
    }

    private void determineWidthAndHeight(int n) {
        this.height = this.width = this.legendProperties.getEdgePadding() * 2.0f;
        if (this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= n) {
            this.numColumns = n;
            this.width += this.textProcessor.getTotalLabelWidths();
            this.numRows = 1;
        } else {
            this.widestLabelAndColumnPadding = this.textProcessor.getWidestLabel() + (float)this.legendProperties.getColumnPadding();
            if (this.legendProperties.getNumColumns() == -1) {
                float f = this.legendProperties.getSize().width;
                float f2 = this.widestLabelAndColumnPadding + this.iconSide + (float)this.legendProperties.getIconPadding() + (float)this.legendProperties.getColumnPadding();
                this.numColumns = (int)(f / f2);
                this.numColumns = Math.min(this.numColumns, n);
            } else {
                this.numColumns = this.legendProperties.getNumColumns();
            }
            this.width += this.textProcessor.getWidestLabel() * (float)this.numColumns;
            this.numRows = (int)Math.ceil((double)n / (double)this.numColumns);
        }
        this.width += (this.iconSide + (float)this.legendProperties.getIconPadding()) * (float)this.numColumns;
        this.width += (float)(this.legendProperties.getColumnPadding() * (this.numColumns - 1));
        if (this.chartType == ChartType.LINE) {
            this.width += (float)(this.legendProperties.getIconLineStrokeLength() * 2 * this.numColumns);
        }
        this.height += this.textProcessor.getTallestLabel() * (float)this.numRows;
        this.height += (float)(this.legendProperties.getRowPadding() * (this.numRows - 1));
    }

    public void render() {
        Graphics2D graphics2D = this.chart.getGraphics2D();
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.x, this.y, this.width - 1.0f, this.height - 1.0f);
        if (this.legendProperties.getBackgroundPaint() != null) {
            graphics2D.setPaint(this.legendProperties.getBackgroundPaint());
            graphics2D.fill(float_);
        }
        if (this.legendProperties.getBorderStroke() != null) {
            this.legendProperties.getBorderStroke().draw(graphics2D, float_);
        }
        graphics2D.setFont(this.legendProperties.getChartFont().getFont());
        float_.y += this.legendProperties.getEdgePadding() + this.textProcessor.getTallestLabel() / 2.0f - this.iconSide / 2.0f;
        float_.width = this.iconSide;
        float_.height = this.iconSide;
        float f = this.x + this.legendProperties.getEdgePadding();
        float f2 = float_.y + float_.height;
        float f3 = this.textProcessor.getTallestLabel() + (float)this.legendProperties.getRowPadding();
        float f4 = this.iconSide + (float)this.legendProperties.getIconPadding();
        int n = 0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                float_.x = f;
                graphics2D.setPaint((Paint)this.paints.get(n));
                if (this.shapes.size() > 0 && this.shapes.size() > n) {
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(float_.x, float_.y);
                    if (this.fillPointsFlags.size() > 0) {
                        if (((Boolean)this.fillPointsFlags.get(n)).booleanValue()) {
                            graphics2D.fill((Shape)this.shapes.get(n));
                            if (this.pointOutlinePaints.get(n) != null) {
                                graphics2D.setPaint((Paint)this.pointOutlinePaints.get(n));
                                graphics2D.draw((Shape)this.shapes.get(n));
                            }
                        }
                    } else if (this.chartType == ChartType.POINT) {
                        graphics2D.draw((Shape)this.shapes.get(n));
                    } else {
                        Rectangle2D rectangle2D = ((Shape)this.shapes.get(n)).getBounds2D();
                        double d = rectangle2D.getWidth() / 2.0;
                        double d2 = rectangle2D.getHeight() / 2.0;
                        graphics2D.setStroke(this.lineChartProperties.getLineStrokes()[n]);
                        Line2D.Double double_ = new Line2D.Double(0.0, d2, this.legendProperties.getIconLineStrokeLength(), d2);
                        graphics2D.draw(double_);
                        f += (float)this.legendProperties.getIconLineStrokeLength();
                        graphics2D.translate((double)this.legendProperties.getIconLineStrokeLength() - d, 0.0);
                        double_.x1 = d;
                        graphics2D.draw(double_);
                        graphics2D.fill((Shape)this.shapes.get(n));
                        if (this.legendProperties.getIconBorderStroke() != null && this.pointOutlinePaints.size() != 0 && this.pointOutlinePaints != null) {
                            graphics2D.setStroke(this.legendProperties.getIconBorderStroke());
                            graphics2D.setPaint((Paint)this.pointOutlinePaints.get(n));
                            graphics2D.draw((Shape)this.shapes.get(n));
                        }
                        f += (float)this.legendProperties.getIconLineStrokeLength();
                    }
                    graphics2D.setTransform(affineTransform);
                } else {
                    graphics2D.fill(float_);
                    if (this.legendProperties.getIconBorderStroke() != null) {
                        graphics2D.setStroke(this.legendProperties.getIconBorderStroke());
                        graphics2D.setPaint(this.legendProperties.getIconBorderPaint());
                        graphics2D.draw(float_);
                    }
                }
                graphics2D.setPaint(this.legendProperties.getChartFont().getPaint());
                graphics2D.drawString((String)this.labels.get(n), f += f4, f2);
                f = this.legendProperties.getNumColumns() == 0 || this.legendProperties.getNumColumns() >= this.labels.size() ? (f += this.textProcessor.getTextTag(n).getWidth() + (float)this.legendProperties.getColumnPadding()) : (f += this.widestLabelAndColumnPadding);
                if (++n == this.labels.size()) break;
            }
            f = this.x + this.legendProperties.getEdgePadding();
            f2 += f3;
            float_.y += f3;
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.legendTableStart();
        hTMLGenerator.addTableRow("Width", Float.toString(this.width));
        hTMLGenerator.addTableRow("Height", Float.toString(this.height));
        hTMLGenerator.addTableRow("Icon Side", Float.toString(this.iconSide));
        hTMLGenerator.innerTableRowStart();
        this.legendProperties.toHTML(hTMLGenerator);
        hTMLGenerator.innerTableRowEnd();
        hTMLGenerator.legendTableEnd();
    }
}

