/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

public class Response
implements Comparable {
    private String iceFacesId;
    private String viewNumber;
    private long sequenceNumber;
    private String entityBody;

    public Response(String iceFacesId, String viewNumber, long sequenceNumber) throws IllegalArgumentException {
        this(iceFacesId, viewNumber, sequenceNumber, "");
    }

    public Response(String iceFacesId, String viewNumber, long sequenceNumber, String entityBody) throws IllegalArgumentException {
        if (iceFacesId == null) {
            throw new IllegalArgumentException("iceFacesId is null");
        }
        if (iceFacesId.trim().length() == 0) {
            throw new IllegalArgumentException("iceFacesId is empty");
        }
        if (viewNumber == null) {
            throw new IllegalArgumentException("viewNumber is null");
        }
        if (viewNumber.trim().length() == 0) {
            throw new IllegalArgumentException("viewNumber is empty");
        }
        if (sequenceNumber <= 0L) {
            throw new IllegalArgumentException("sequenceNumber <= 0");
        }
        this.iceFacesId = iceFacesId;
        this.viewNumber = viewNumber;
        this.sequenceNumber = sequenceNumber;
        this.entityBody = entityBody != null ? entityBody : "";
    }

    public int compareTo(Object object) throws ClassCastException {
        if (!(object instanceof Response)) {
            throw new ClassCastException("object is not a Response");
        }
        Response _response = (Response)object;
        int _result = this.iceFacesId.compareTo(_response.iceFacesId);
        if (_result != 0) {
            return _result;
        }
        _result = this.viewNumber.compareTo(_response.viewNumber);
        if (_result != 0) {
            return _result;
        }
        if (this.sequenceNumber < _response.sequenceNumber) {
            return -1;
        }
        if (this.sequenceNumber > _response.sequenceNumber) {
            return 1;
        }
        return 0;
    }

    public String getEntityBody() {
        return this.entityBody;
    }

    public String getICEfacesID() {
        return this.iceFacesId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public boolean isEmpty() {
        return this.entityBody.trim().length() == 0;
    }
}

