/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebEndpoint;
import org.apache.axis2.jaxws.description.builder.ActionAnnot;
import org.apache.axis2.jaxws.description.builder.FaultActionAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.RequestWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ResponseWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.WebEndpointAnnot;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.builder.WebResultAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;
import org.apache.axis2.jaxws.description.builder.converter.JavaParamToPDCConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodsToMDCConverter {
    private Method[] methods;
    private Constructor[] constructors;
    private String declaringClass;

    public JavaMethodsToMDCConverter(Method[] methods, Constructor[] constructors, String declaringClass) {
        this.methods = methods;
        this.constructors = constructors;
        this.declaringClass = declaringClass;
    }

    public List<MethodDescriptionComposite> convertMethods() {
        List<ParameterDescriptionComposite> pdcList;
        JavaParamToPDCConverter paramConverter;
        MethodDescriptionComposite mdc;
        ArrayList<MethodDescriptionComposite> mdcList = new ArrayList<MethodDescriptionComposite>();
        for (Method method : this.methods) {
            if (ConverterUtils.isInherited(method, this.declaringClass) || !Modifier.isPublic(method.getModifiers())) continue;
            mdc = new MethodDescriptionComposite();
            this.setExceptionList(mdc, method);
            mdc.setMethodName(method.getName());
            this.setReturnType(mdc, method);
            this.setIsListType(mdc, method);
            mdc.setDeclaringClass(method.getDeclaringClass().getName());
            this.attachHandlerChainAnnotation(mdc, method);
            this.attachOnewayAnnotation(mdc, method);
            this.attachSoapBindingAnnotation(mdc, method);
            this.attachRequestWrapperAnnotation(mdc, method);
            this.attachResponseWrapperAnnotation(mdc, method);
            this.attachWebEndpointAnnotation(mdc, method);
            this.attachWebMethodAnnotation(mdc, method);
            this.attachWebResultAnnotation(mdc, method);
            this.attachWebServiceRefAnnotation(mdc, method);
            this.attachActionAnnotation(mdc, method);
            if (method.getGenericParameterTypes().length > 0) {
                paramConverter = new JavaParamToPDCConverter(method.getGenericParameterTypes(), method.getParameterAnnotations());
                pdcList = paramConverter.convertParams();
                ConverterUtils.attachParameterDescriptionComposites(pdcList, mdc);
            }
            mdcList.add(mdc);
        }
        for (Executable executable : this.constructors) {
            mdc = new MethodDescriptionComposite();
            mdc.setMethodName("<init>");
            mdc.setDeclaringClass(((Constructor)executable).getDeclaringClass().getName());
            mdcList.add(mdc);
            if (((Constructor)executable).getGenericParameterTypes().length <= 0) continue;
            paramConverter = new JavaParamToPDCConverter(((Constructor)executable).getGenericParameterTypes(), ((Constructor)executable).getParameterAnnotations());
            pdcList = paramConverter.convertParams();
            ConverterUtils.attachParameterDescriptionComposites(pdcList, mdc);
        }
        return mdcList;
    }

    private void setExceptionList(MethodDescriptionComposite mdc, Method method) {
        if (method.getExceptionTypes().length > 0) {
            Type[] exceptionTypes = method.getGenericExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Type type = exceptionTypes[i];
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    String fullType = "";
                    exceptions[i] = fullType = ConverterUtils.getFullType(pt, fullType);
                    continue;
                }
                if (!(type instanceof Class)) continue;
                exceptions[i] = ((Class)type).getName();
            }
            mdc.setExceptions(exceptions);
        }
    }

    private void attachHandlerChainAnnotation(MethodDescriptionComposite mdc, Method method) {
        ConverterUtils.attachHandlerChainAnnotation(mdc, method);
    }

    private void attachSoapBindingAnnotation(MethodDescriptionComposite mdc, Method method) {
        ConverterUtils.attachSoapBindingAnnotation(mdc, method);
    }

    private void attachOnewayAnnotation(MethodDescriptionComposite mdc, Method method) {
        Oneway oneway = (Oneway)ConverterUtils.getAnnotation(Oneway.class, method);
        if (oneway != null) {
            mdc.setOneWayAnnot(true);
        } else {
            mdc.setOneWayAnnot(false);
        }
    }

    private void attachRequestWrapperAnnotation(MethodDescriptionComposite mdc, Method method) {
        RequestWrapper requestWrapper = (RequestWrapper)ConverterUtils.getAnnotation(RequestWrapper.class, method);
        if (requestWrapper != null) {
            RequestWrapperAnnot rwAnnot = RequestWrapperAnnot.createRequestWrapperAnnotImpl();
            rwAnnot.setClassName(requestWrapper.className());
            rwAnnot.setLocalName(requestWrapper.localName());
            rwAnnot.setTargetNamespace(requestWrapper.targetNamespace());
            mdc.setRequestWrapperAnnot(rwAnnot);
        }
    }

    private void attachResponseWrapperAnnotation(MethodDescriptionComposite mdc, Method method) {
        ResponseWrapper responseWrapper = (ResponseWrapper)ConverterUtils.getAnnotation(ResponseWrapper.class, method);
        if (responseWrapper != null) {
            ResponseWrapperAnnot rwAnnot = ResponseWrapperAnnot.createResponseWrapperAnnotImpl();
            rwAnnot.setClassName(responseWrapper.className());
            rwAnnot.setLocalName(responseWrapper.localName());
            rwAnnot.setTargetNamespace(responseWrapper.targetNamespace());
            mdc.setResponseWrapperAnnot(rwAnnot);
        }
    }

    private void attachWebEndpointAnnotation(MethodDescriptionComposite mdc, Method method) {
        WebEndpoint webEndpoint = (WebEndpoint)ConverterUtils.getAnnotation(WebEndpoint.class, method);
        if (webEndpoint != null) {
            WebEndpointAnnot weAnnot = WebEndpointAnnot.createWebEndpointAnnotImpl();
            weAnnot.setName(webEndpoint.name());
            mdc.setWebEndpointAnnot(weAnnot);
        }
    }

    private void attachWebMethodAnnotation(MethodDescriptionComposite mdc, Method method) {
        WebMethod webMethod = (WebMethod)ConverterUtils.getAnnotation(WebMethod.class, method);
        if (webMethod != null) {
            WebMethodAnnot wmAnnot = WebMethodAnnot.createWebMethodAnnotImpl();
            wmAnnot.setAction(webMethod.action());
            wmAnnot.setExclude(webMethod.exclude());
            wmAnnot.setOperationName(webMethod.operationName());
            mdc.setWebMethodAnnot(wmAnnot);
        }
    }

    private void attachWebResultAnnotation(MethodDescriptionComposite mdc, Method method) {
        WebResult webResult = (WebResult)ConverterUtils.getAnnotation(WebResult.class, method);
        if (webResult != null) {
            WebResultAnnot wrAnnot = WebResultAnnot.createWebResultAnnotImpl();
            wrAnnot.setHeader(webResult.header());
            wrAnnot.setName(webResult.name());
            wrAnnot.setPartName(webResult.partName());
            wrAnnot.setTargetNamespace(webResult.targetNamespace());
            mdc.setWebResultAnnot(wrAnnot);
        }
    }

    private void attachWebServiceRefAnnotation(MethodDescriptionComposite mdc, Method method) {
        ConverterUtils.attachWebServiceRefAnnotation(mdc, method);
    }

    private void attachActionAnnotation(MethodDescriptionComposite mdc, Method method) {
        Action action = (Action)ConverterUtils.getAnnotation(Action.class, method);
        if (action != null) {
            ActionAnnot actionAnnot = ActionAnnot.createActionAnnotImpl();
            FaultAction[] faults = action.fault();
            if (faults != null && faults.length != 0) {
                ArrayList<FaultActionAnnot> list = new ArrayList<FaultActionAnnot>();
                for (FaultAction fault : faults) {
                    FaultActionAnnot faultAnnot = FaultActionAnnot.createFaultActionAnnotImpl();
                    faultAnnot.setClassName(fault.className());
                    faultAnnot.setValue(fault.value());
                    list.add(faultAnnot);
                }
                actionAnnot.setFault(list.toArray(new FaultAction[0]));
            }
            actionAnnot.setInput(action.input());
            actionAnnot.setOutput(action.output());
            mdc.setActionAnnot(actionAnnot);
        }
    }

    private void setReturnType(MethodDescriptionComposite mdc, Method method) {
        Type type = method.getGenericReturnType();
        if (type == null) {
            mdc.setReturnType("void");
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            String fullType = "";
            fullType = ConverterUtils.getFullType(pt, fullType);
            mdc.setReturnType(fullType);
        } else if (type instanceof Class) {
            mdc.setReturnType(((Class)type).getName());
        }
    }

    private void setIsListType(MethodDescriptionComposite mdc, Method method) {
        mdc.setIsListType(ConverterUtils.hasXmlListAnnotation(method.getAnnotations()));
    }
}

