/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CharacterDataImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements CharacterData,
Text {
    static final long serialVersionUID = -5294980852957403469L;

    public TextImpl() {
    }

    public TextImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl, string);
    }

    public void setValues(CoreDocumentImpl coreDocumentImpl, String string) {
        this.flags = 0;
        this.nextSibling = null;
        this.previousSibling = null;
        this.setOwnerDocument(coreDocumentImpl);
        this.data = string;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public void setIgnorableWhitespace(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIgnorableWhitespace(bl);
    }

    public boolean isElementContentWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public String getWholeText() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.nextSibling == null) {
            return this.data;
        }
        if (this.fBufferStr == null) {
            this.fBufferStr = new StringBuffer();
        } else {
            this.fBufferStr.setLength(0);
        }
        if (this.data != null && this.data.length() != 0) {
            this.fBufferStr.append(this.data);
        }
        this.getWholeText(this.nextSibling, this.fBufferStr);
        return this.fBufferStr.toString();
    }

    private boolean getWholeText(Node node, StringBuffer stringBuffer) {
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5) {
                if (this.getWholeText(node.getFirstChild(), stringBuffer)) {
                    return true;
                }
            } else if (s == 3 || s == 4) {
                ((NodeImpl)node).getTextContent(stringBuffer);
            } else {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Text replaceWholeText(String string) throws DOMException {
        void var4_9;
        void var3_6;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.canModify(this.nextSibling)) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        Node node = this.getParentNode();
        if ((string == null || string.length() == 0) && node != null) {
            node.removeChild(this);
            return null;
        }
        Object var3_3 = null;
        if (this.isReadOnly()) {
            Text text = this.ownerDocument().createTextNode(string);
            if (node == null) return text;
            node.insertBefore(text, this);
            node.removeChild(this);
            Text text2 = text;
        } else {
            this.setData(string);
            TextImpl textImpl = this;
        }
        Node node2 = var3_6.getNextSibling();
        while (var4_9 != null) {
            node.removeChild((Node)var4_9);
            Node node3 = var3_6.getNextSibling();
        }
        return var3_6;
    }

    private boolean canModify(Node node) {
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5 ? !this.canModify(node.getFirstChild()) : s != 3 && s != 4) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public boolean isIgnorableWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public Text splitText(int n) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (n < 0 || n > this.data.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        Text text = this.getOwnerDocument().createTextNode(this.data.substring(n));
        this.setNodeValue(this.data.substring(0, n));
        Node node = this.getParentNode();
        if (node != null) {
            node.insertBefore(text, this.nextSibling);
        }
        return text;
    }

    public void replaceData(String string) {
        this.data = string;
    }

    public String removeData() {
        String string = this.data;
        this.data = "";
        return string;
    }
}

