package de.dass_it.vanhelsing.gui;
import java.io.*;
/*
 * Einlesen der Dateien dird_conf.c, filed_conf.c und stored_conf.c
 */


public class ValidationParser{
	
	public static void main(String args[]) {
		try {
		FileInputStream fs = new FileInputStream(args[1]);
		DataInputStream ds = new DataInputStream(fs);
		BufferedReader br = new BufferedReader(new InputStreamReader(ds));
		String line;
		String[] lineParts;
		String name ="FEHLER"; //Resourcename
		String daemon = args[0];
		
		String item; 	//Resourcenitem
		String type; 	//Resourcentype
		String ref;		//Referenz auf andere Resourcen
		String nec;		//Kann oder Mussfeld
		String def;		//defaultwert
		
		String state = "";
		while ((line = br.readLine()) != null){
			//Zeile enthält entweder Resourcenname oder Resourcenteildefinition
			if (line.startsWith("static RES_ITEM")){
				lineParts = line.split(" ");
				name = lineParts[2].substring(0, (lineParts[2].length()-2));
				state = "res";
				continue;
			}
			if (line.startsWith("RES_ITEM")){
				lineParts = line.split(" ");
				name = lineParts[1].substring(0, (lineParts[1].length()-2));
				state = "res";
				continue;
				
			}
			if (line.startsWith("};")){
				state = "";
				continue;
			}
			if (line.contains("{NULL")){
				continue;
			}
			if (line.split(",").length != 6){
				continue;
			}
			if (state.equals("res")){
				lineParts = line.split(",");
				item = lineParts[0].replaceAll(" ", "");
				item = item.replaceAll("\\{", "");
				item = item.replaceAll("\"", "");
				type = lineParts[1].replaceAll(" ", "");
				type = type.replaceAll("\"", "");
				ref = lineParts[3];
				nec = lineParts[4];
				def = lineParts[5].replaceAll("\\}", "");
				System.out.println(daemon+"."+getPrettyName(name)+"."+item+"."+"ref" + " = " + getReferenz(ref));
				System.out.println(daemon+"."+getPrettyName(name)+"."+item+"."+"type" + " = " +getJavaType(type));
				System.out.println(daemon+"."+getPrettyName(name)+"."+item+"."+"required" + " = " +getJavaReq(nec));
				System.out.println(daemon+"."+getPrettyName(name)+"."+item+"."+"def" + " = " +def);
				continue;
			}
		}
		ds.close();
		} catch (Exception e){
			e.printStackTrace();
		}
	}
	
	private static String getReferenz(String s){
		return s;
	}
	
	private static String getJavaType(String s){
		for (conf2type c2t : conf2type.values()){
			if (c2t.conf.equals(s)){
				return c2t.type;
			}
		}
		/*if (s.equals("store_bool") || s.equals("store_bit") ){
			return "boolean";
		}
		if (s.equals("store_str") || s.equals("store_name") || s.equals("store_strname")){
			return "String";
		}
		if (s.equals("store_pint32")||s.equals("store_size")){
			return "int";
		}
		if (s.equals("store_dir")){
			return "Path";
		}
		if (s.equals("store_password")){
			return "Password";
		}
		if (s.equals("store_time")){
			return "Date";
		}
		if (s.equals("store_acl")){
			return "Acl";
		}
		if (s.equals("store_res")){
			return "Resource";
		}*/
		//switch(s){
			//case "store_bool" 		: s = "boolean"; break;
			//case "store_pint32" 	: s = "int"; break;
			//case "store_str" 		: s = "String"; 
			//case "store_name"    	: s = "String"; break;
			//case "store_dir"     	: s = "Path"; break;
			//case "store_password" 	: s = "Password"; break;
			//case "store_time"    	: s = "Date"; break;
			//case "store_bit"     	: s = "boolean"; break;
			//case "store_size"    	: s = "int"; break;
			//case "store_acl"     	: s = "Acl"; break;
			//case "store_strname" 	: s = "String"; break;
			//case "store_res"     	: s = "Resource"; break;
		//}
		return s;
	}
	private static String getJavaReq(String s){
		if ( s.contains("ITEM_REQUIRED") ){
			s = "true";
		} else {
			s = "false";
		}
		return s;
	}
	private static String getPrettyName(String s){
		for (prettyNames name : prettyNames.values()){
			if (name.ugly.equals(s)){
				return name.pretty;
			}
		}
			
		return s;
	}
	/**
	 * @author   tgoecke
	 */
	private enum prettyNames{
		CATALOG ("cat_items", "catalog"),
		CLIENT ("cli_items", "client"),
		CONSOLE ("con_items", "console"),	
		COUNTER ("counter_items", "counter"),
		DIRECTOR ("dir_items", "director"),
		FILESET ("fs_items", "fileset"),
		POOL ("pool_items", "pool"),
		RUNSCRIPT ("runscript_items", "runscript"),
		SCHEDULE ("sch_items", "schedule"),
		STORAGE ("store_items", "storage"),
		AUTOCHANGER ("changer_items", "autochanger"),
		DEVICE ("dev_items", "device"),
		JOB("job_items", "job"),
		MESSAGE("msgs_item","message");
		
		private String ugly;
		private String pretty;
		
		prettyNames(String ugly, String pretty){
			this.ugly = ugly;
			this.pretty = pretty;
		}
	}
	/**
	 * @author   tgoecke
	 */
	private enum conf2type{
		/**
		 * @uml.property  name="sTOREPOOL"
		 * @uml.associationEnd  
		 */
		STOREPOOL ("store_pool", "boolean"),
		/**
		 * @uml.property  name="sTOREBIT"
		 * @uml.associationEnd  
		 */
		STOREBIT ("store_bit","boolean"),
		/**
		 * @uml.property  name="sTORE_STR"
		 * @uml.associationEnd  
		 */
		STORE_STR ("store_str","String"),
		/**
		 * @uml.property  name="sTORE_NAME"
		 * @uml.associationEnd  
		 */
		STORE_NAME ("store_name", "String"),
		/**
		 * @uml.property  name="sTORE_STRNAME"
		 * @uml.associationEnd  
		 */
		STORE_STRNAME ("store_strname", "String"),
		/**
		 * @uml.property  name="sTORE_PINT32"
		 * @uml.associationEnd  
		 */
		STORE_PINT32 ("store_pint32", "int"),
		/**
		 * @uml.property  name="sTORE_SIZE"
		 * @uml.associationEnd  
		 */
		STORE_SIZE ("store_size", "int"),
		/**
		 * @uml.property  name="sTORE_DIR"
		 * @uml.associationEnd  
		 */
		STORE_DIR ("store_dir", "path"),
		/**
		 * @uml.property  name="sTORE_PASSWORD"
		 * @uml.associationEnd  
		 */
		STORE_PASSWORD ("store_password", "Password"),
		/**
		 * @uml.property  name="sTORE_TIME"
		 * @uml.associationEnd  
		 */
		STORE_TIME ("store_time", "Date"),
		/**
		 * @uml.property  name="sTORE_ACL"
		 * @uml.associationEnd  
		 */
		STORE_ACL ("store_acl", "Acl"),
		/**
		 * @uml.property  name="sTORE_RES"
		 * @uml.associationEnd  
		 */
		STORE_RES ("store_res", "Resource");
		
		private String conf;
		private String type;
		
		conf2type(String conf, String type){
			this.conf = conf;
			this.type = type;
		}
	}
}
