package de.dass_it.vanhelsing.gui;

import java.util.ArrayList;

import de.dass_it.vanhelsing.gui.items.ConcreteUserObjectItem;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;
import de.dass_it.www.vanhelsing.VanHelsingStub.ResourceAttributeType;
import de.dass_it.www.vanhelsing.VanHelsingStub.ResourceInfo;

public class UserObjectItemFactory {
	
	public UserObjectItem createUserObjectItem(ResourceInfo ri){
		ConcreteUserObjectItem obj = new ConcreteUserObjectItem();
		obj.setResId(ri.getResId());
		obj.setResName(ri.getResName());
		obj.setResType(ri.getResType());
		obj.setDirector(ri.getDirector());
		return obj;
	}
	
	public UserObjectItem createUserObjectItem(ResourceAttributeType ra[], ResourceInfo ri){
		ConcreteUserObjectItem obj = (ConcreteUserObjectItem)createUserObjectItem(ri);
		ArrayList<ViewItem> viewItemList = new ArrayList<ViewItem>();
		ViewItem vi;
		for (ResourceAttributeType attr : ra){
			vi = new ViewItem();
			vi.setDataType(BeanUtil.getDataType(obj.getResType(), attr.getKey()));
			vi.setRendererFlag(BeanUtil.getRenderer(obj.getResType(), attr.getKey()));
			vi.setRequired(BeanUtil.getRequired(obj.getResType(), attr.getKey()));
			vi.setKey(attr.getKey());
			vi.setKeyValue(attr.getValue());
			viewItemList.add(vi);
		}
		obj.setViewItemList(viewItemList);
		return obj;
	}
}
