package de.dass_it.vanhelsing.gui;

import org.apache.axis2.*;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;

public class Client {
	public void connect() {
		VanHelsingStub stub;
		try {
			stub = new VanHelsingStub("http://localhost:8080/");
			
			getResourceList(stub);
			
		} catch (Exception e){
			e.printStackTrace();
		}
	}

	public void getResourceList(VanHelsingStub stub){
		ListResourcesType arg0 = new ListResourcesType();
		arg0.setDirector("bacula-dir");
		arg0.setResourceType("Job");
		try{
			
			VanHelsingStub.ListResources req = new VanHelsingStub.ListResources();
			req.setListResources(arg0);
			
			VanHelsingStub.ListResourcesResponse res = stub.listResources(req);
			ResourceInfo[] ergebnis = (res.getListResourcesResponse()).getResource();

			for (int i = 0; i < ergebnis.length; i++){
				System.err.println(ergebnis[i].getResId());
				System.err.println(ergebnis[i].getResName());
				System.err.println(ergebnis[i].getResType());
				System.err.println(ergebnis[i].getDirector());
			}

			//System.err.println("\n\n!!!!res.toString()");
			//System.err.println(res.toString());
			//System.err.println("\n\n");
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}	
	
	public ResourceInfo[] getListResources(ListResourcesType lrt){
		VanHelsingStub stub;
		try {
			//ohne chunked
			Options options = new Options();
			options.setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.TRUE);
						 
			stub = new VanHelsingStub("http://localhost:8080/");
			
			VanHelsingStub.ListResources req = new VanHelsingStub.ListResources();
			req.setListResources(lrt);
			
			VanHelsingStub.ListResourcesResponse res = stub.listResources(req);
			return (res.getListResourcesResponse()).getResource();
			
		} catch (Exception e){
			e.printStackTrace();
		}
		return new ResourceInfo[0];
	}
	
	/*public ResourceItem[] getListResourceItems(ListResourcesType lrt){
		VanHelsingStub stub;
		try {
			stub = new VanHelsingStub("http://localhost:8080/");
			
			VanHelsingStub.ListResourceItems req = new VanHelsingStub.ListResourceItems();
			req.setListResourceItems(lrt);
			
			VanHelsingStub.ListResourceItemsResponse res = stub.listResourceItems(req);
			return (res.getListResourceItemsResponse()).getResourceItemListElement();
			
		} catch (Exception e){
			e.printStackTrace();
		}
		return new ResourceItem[0];
	}*/
	
	public static void main(String args[]){
		Client c = new Client();
		//c.connect();
		
		ListResourcesType lrt = new ListResourcesType();
		lrt.setDirector("bacula-dir");
		lrt.setResourceType("JobDefs");
		
		ResourceInfo[] rinfo = c.getListResources(lrt);
	
		//ResourceItem[] ritem = c.getListResourceItems(lrt);
		
		System.err.println("!!!rinfo!!!");
		for (int i = 0; i < rinfo.length && rinfo.length > 0; i++){
			System.err.println(rinfo[i].getDirector());
			System.err.println(rinfo[i].getResId());
			System.err.println(rinfo[i].getResName());
			System.err.println(rinfo[i].getResType());
		}
		
		/*System.err.println("!!!ritem!!!");
		for (int i = 0; i < ritem.length && ritem.length > 0; i++){
			System.err.println(ritem[i].getDirector());
			System.err.println(ritem[i].getResId());
			System.err.println(ritem[i].getResKey());
			System.err.println(ritem[i].getResName());
			System.err.println(ritem[i].getResValue());
		}
		*/
	}

}
